/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.ui.workflow.AssignedTaskTableModelBuilder;
import com.arsdigita.cms.ui.workflow.WorkflowRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.User;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public final class AssignedTaskTable
extends Table {
    private static final Logger s_log = Logger.getLogger(AssignedTaskTable.class);

    public AssignedTaskTable(WorkflowRequestLocal workflow) {
        super((TableModelBuilder)new AssignedTaskTableModelBuilder(workflow), (Object[])new String[]{AssignedTaskTable.lz("cms.ui.name"), "", ""});
        this.setEmptyView((Component)new Label(AssignedTaskTable.gz("cms.ui.workflow.task.assigned.none")));
        this.addTableActionListener((TableActionListener)new LockListener());
        this.getColumn(1).setCellRenderer((TableCellRenderer)new CellRenderer());
        this.getColumn(2).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(true));
    }

    protected static final GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize(key);
    }

    protected static final String lz(String key) {
        return (String)AssignedTaskTable.gz(key).localize();
    }

    private class CellRenderer
    implements TableCellRenderer {
        private CellRenderer() {
        }

        public final Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            BoxPanel p = new BoxPanel();
            User lockingUser = (User)value;
            if (lockingUser != null) {
                StringBuffer sb = new StringBuffer("Locked by <br />");
                if (lockingUser.equals((Object)Web.getContext().getUser())) {
                    sb.append("you");
                    p.add((Component)new ControlLink((Component)new Label(AssignedTaskTable.gz("cms.ui.workflow.task.unlock"))));
                } else {
                    sb.append(lockingUser.getName());
                    p.add((Component)new ControlLink((Component)new Label(AssignedTaskTable.gz("cms.ui.workflow.task.takeover"))));
                }
                p.add((Component)new Label(sb.toString(), false));
            } else {
                p.add((Component)new ControlLink((Component)new Label(AssignedTaskTable.gz("cms.ui.workflow.task.lock"))));
            }
            return p;
        }
    }

    private static class LockListener
    extends TableActionAdapter {
        private LockListener() {
        }

        public final void cellSelected(TableActionEvent e) {
            int column = e.getColumn();
            if (column == 1) {
                CMSTask task = new CMSTask(new BigDecimal(e.getRowKey().toString()));
                User currentUser = Web.getContext().getUser();
                User lockingUser = task.getLockedUser();
                if (task.isLocked() && lockingUser != null && lockingUser.equals((Object)currentUser)) {
                    task.unlock(currentUser);
                } else {
                    task.lock(currentUser);
                }
                task.save();
            }
        }
    }
}

