/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.cms.ui.workflow.WorkflowRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.cms.workflow.CMSTaskType;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.Engine;
import com.arsdigita.workflow.simple.Workflow;
import java.util.Iterator;
import org.apache.log4j.Logger;

class AssignedTaskTableModelBuilder
extends AbstractTableModelBuilder {
    private static final Logger s_log = Logger.getLogger(AssignedTaskTableModelBuilder.class);
    private final WorkflowRequestLocal m_workflow;

    public AssignedTaskTableModelBuilder(WorkflowRequestLocal workflow) {
        this.m_workflow = workflow;
    }

    public TableModel makeModel(Table table, PageState state) {
        return new Model(this.m_workflow.getWorkflow(state));
    }

    protected static final GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize(key);
    }

    protected static final String lz(String key) {
        return (String)AssignedTaskTableModelBuilder.gz(key).localize();
    }

    private static class Model
    implements TableModel {
        private final Iterator m_iter;
        private CMSTask m_task;

        Model(Workflow workflow) {
            Assert.exists((Object)workflow, Workflow.class);
            Engine engine = Engine.getInstance((String)"cms");
            Assert.exists((Object)engine, Engine.class);
            this.m_iter = engine.getEnabledTasks(Web.getContext().getUser(), workflow.getID()).iterator();
        }

        public final int getColumnCount() {
            return 3;
        }

        public final boolean nextRow() {
            if (this.m_iter.hasNext()) {
                this.m_task = (CMSTask)((Object)this.m_iter.next());
                return true;
            }
            return false;
        }

        public final Object getKeyAt(int column) {
            return this.m_task.getID();
        }

        public final Object getElementAt(int column) {
            switch (column) {
                case 0: {
                    return this.m_task.getLabel();
                }
                case 1: {
                    return this.m_task.isLocked() ? this.m_task.getLockedUser() : null;
                }
                case 2: {
                    return this.m_task.getTaskType().getID().equals(CMSTaskType.DEPLOY) ? new Label("") : AssignedTaskTableModelBuilder.lz("cms.ui.workflow.task.finish");
                }
            }
            throw new IllegalStateException();
        }
    }
}

