/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ui.BaseForm;
import com.arsdigita.cms.ui.DataCollectionOptionPrintListener;
import com.arsdigita.cms.ui.workflow.WorkflowRequestLocal;
import com.arsdigita.cms.workflow.CMSTaskType;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.workflow.simple.Task;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

class BaseTaskForm
extends BaseForm {
    private static final Logger s_log = Logger.getLogger(BaseTaskForm.class);
    final WorkflowRequestLocal m_workflow;
    final TextField m_name;
    final TextArea m_description;
    final OptionGroup m_type;
    final OptionGroup m_deps;

    BaseTaskForm(String key, GlobalizedMessage message, WorkflowRequestLocal workflow) {
        super(key, message);
        this.m_workflow = workflow;
        this.m_name = new BaseForm.Name("name", 200, true);
        this.addField(BaseTaskForm.gz("cms.ui.name"), (Component)this.m_name);
        this.m_type = new SingleSelect((ParameterModel)new IntegerParameter("task_type"));
        this.addField(BaseTaskForm.gz("cms.ui.workflow.task.type"), (Component)this.m_type);
        try {
            this.m_type.addPrintListener((PrintListener)new TaskTypePrintListener());
        }
        catch (TooManyListenersException tmle) {
            throw new UncheckedWrapperException((Throwable)tmle);
        }
        this.m_description = new BaseForm.Description("desc", 4000, true);
        this.addField(BaseTaskForm.gz("cms.ui.description"), (Component)this.m_description);
        this.m_deps = new CheckboxGroup("dep");
        this.addField(BaseTaskForm.gz("cms.ui.workflow.task.dependencies"), (Component)this.m_deps);
        this.addAction(new BaseForm.Finish());
        this.addAction(new BaseForm.Cancel());
        this.addSecurityListener("workflow_admin");
        this.addValidationListener(new ValidationListener());
    }

    final void processDependencies(Task t, String[] selectedDependencies) {
        Iterator iter = t.getDependencies();
        HashMap<BigDecimal, Task> toAdd = new HashMap<BigDecimal, Task>();
        HashMap<BigDecimal, Task> toRemove = new HashMap<BigDecimal, Task>();
        while (iter.hasNext()) {
            Task temp = (Task)iter.next();
            toRemove.put(temp.getID(), temp);
        }
        if (selectedDependencies != null) {
            for (int i = 0; i < selectedDependencies.length; ++i) {
                BigDecimal b = new BigDecimal(selectedDependencies[i]);
                Object addedTask = toRemove.remove(b);
                if (addedTask != null) continue;
                toAdd.put(b, new Task(b));
            }
        }
        iter = toRemove.values().iterator();
        while (iter.hasNext()) {
            t.removeDependency((Task)iter.next());
        }
        iter = toAdd.values().iterator();
        while (iter.hasNext()) {
            t.addDependency((Task)iter.next());
        }
    }

    private class TaskTypePrintListener
    extends DataCollectionOptionPrintListener {
        private TaskTypePrintListener() {
        }

        @Override
        protected DataCollection getDataCollection(PageState s) {
            DataCollection taskTypes = SessionManager.getSession().retrieve("com.arsdigita.cms.workflow.CMSTaskType");
            taskTypes.addOrder("upper(name)");
            return taskTypes;
        }

        @Override
        public String getKey(DomainObject d) {
            return ((CMSTaskType)d).getID().toString();
        }

        @Override
        public String getValue(DomainObject d) {
            return ((CMSTaskType)d).getName();
        }
    }

    private class ValidationListener
    implements FormValidationListener {
        private ValidationListener() {
        }

        public final void validate(FormSectionEvent e) throws FormProcessException {
            String name = (String)BaseTaskForm.this.m_name.getValue(e.getPageState());
        }
    }
}

