/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.cms.ui.BaseForm;
import com.arsdigita.cms.ui.workflow.TaskRequestLocal;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.kernel.User;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.TaskComment;
import org.apache.log4j.Logger;

class CommentAddForm
extends BaseForm {
    private static final Logger s_log = Logger.getLogger(CommentAddForm.class);
    private final TaskRequestLocal m_task;
    private final TextArea m_comment;

    public CommentAddForm(TaskRequestLocal task) {
        super("addComment", CommentAddForm.gz("cms.ui.workflow.task.comment.add"));
        this.m_task = task;
        this.m_comment = new TextArea("Comment");
        this.m_comment.setWrap(2);
        this.m_comment.setRows(5);
        this.m_comment.setCols(40);
        this.addComponent((Component)this.m_comment);
        this.addAction(new BaseForm.Finish());
        this.addAction(new BaseForm.Cancel());
        this.addProcessListener(new ProcessListener());
    }

    private class ProcessListener
    implements FormProcessListener {
        private ProcessListener() {
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            s_log.debug((Object)"Processing comment add");
            PageState state = e.getPageState();
            CMSTask task = CommentAddForm.this.m_task.getTask(state);
            User user = Web.getContext().getUser();
            TaskComment comment = new TaskComment(task.getID(), user, (String)CommentAddForm.this.m_comment.getValue(state));
            comment.save();
            task.addComment(comment);
            task.save();
        }
    }
}

