/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.ui.workflow.AssignedTaskSection;
import com.arsdigita.cms.ui.workflow.AssignedTaskTable;
import com.arsdigita.cms.ui.workflow.BaseWorkflowItemPane;
import com.arsdigita.cms.ui.workflow.TaskFinishForm;
import com.arsdigita.cms.ui.workflow.TaskRequestLocal;
import com.arsdigita.cms.ui.workflow.WorkflowRequestLocal;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.Workflow;
import java.math.BigDecimal;

final class ItemWorkflowItemPane
extends BaseWorkflowItemPane {
    private final AssignedTaskTable m_assigned;

    public ItemWorkflowItemPane(WorkflowRequestLocal workflow, ActionLink editLink, ActionLink deleteLink) {
        super(workflow, editLink, deleteLink);
        this.m_actionGroup.addAction((Component)new BaseWorkflowItemPane.AdminVisible((Component)new StartLink()));
        this.m_actionGroup.addAction((Component)new BaseWorkflowItemPane.AdminVisible((Component)new StopLink()));
        this.m_assigned = new AssignedTaskTable(workflow);
        this.m_detailPane.add((Component)new AssignedTaskSection(workflow, (Component)this.m_assigned));
        TaskFinishForm taskFinishForm = new TaskFinishForm(new TaskSelectionRequestLocal());
        this.add((Component)taskFinishForm);
        this.connect(this.m_assigned, 2, (FormSection)taskFinishForm);
        this.connect((FormSection)taskFinishForm);
    }

    private boolean hasAdmin(PageState state) {
        SecurityManager sm = CMS.getContext().getSecurityManager();
        return sm.canAccess(state.getRequest(), "workflow_admin");
    }

    private class StartLink
    extends ActionLink {
        StartLink() {
            super((Component)new Label(ItemWorkflowItemPane.gz("cms.ui.item.workflow.start")));
            this.addActionListener(new Listener());
        }

        public final boolean isVisible(PageState state) {
            Workflow workflow = ItemWorkflowItemPane.this.m_workflow.getWorkflow(state);
            return workflow.getProcessState() == 1;
        }

        private class Listener
        implements ActionListener {
            private Listener() {
            }

            public final void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                if (ItemWorkflowItemPane.this.hasAdmin(state)) {
                    Workflow workflow = ItemWorkflowItemPane.this.m_workflow.getWorkflow(state);
                    workflow.start(Web.getContext().getUser());
                }
            }
        }
    }

    private class StopLink
    extends ActionLink {
        StopLink() {
            super((Component)new Label(ItemWorkflowItemPane.gz("cms.ui.item.workflow.stop")));
            this.addActionListener(new Listener());
        }

        public final boolean isVisible(PageState state) {
            Workflow workflow = ItemWorkflowItemPane.this.m_workflow.getWorkflow(state);
            return workflow.getProcessState() == 0;
        }

        private class Listener
        implements ActionListener {
            private Listener() {
            }

            public final void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                if (ItemWorkflowItemPane.this.hasAdmin(state)) {
                    Workflow workflow = ItemWorkflowItemPane.this.m_workflow.getWorkflow(state);
                    workflow.stop(Web.getContext().getUser());
                }
            }
        }
    }

    private final class TaskSelectionRequestLocal
    extends TaskRequestLocal {
        private TaskSelectionRequestLocal() {
        }

        protected final Object initialValue(PageState state) {
            String id = ItemWorkflowItemPane.this.m_assigned.getRowSelectionModel().getSelectedKey(state).toString();
            return new CMSTask(new BigDecimal(id));
        }
    }
}

