/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.cms.ui.workflow.WorkflowsOptionPrintListener;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.Workflow;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import java.math.BigDecimal;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

class ItemWorkflowSelectForm
extends CMSForm {
    private static final Logger s_log = Logger.getLogger(ItemWorkflowSelectForm.class);
    private RadioGroup m_radio;

    public ItemWorkflowSelectForm() {
        super("applyWorkflow", (Container)new SimpleContainer());
        this.addFormWidgets();
        this.addProcessListener(new ProcessListener());
    }

    protected void addFormWidgets() {
        this.m_radio = new RadioGroup((ParameterModel)new BigDecimalParameter("workflowSelect"));
        this.m_radio.setClassAttr("vertical");
        try {
            this.m_radio.addPrintListener((PrintListener)new WorkflowsOptionPrintListener());
        }
        catch (TooManyListenersException t) {
            s_log.error((Object)"Too many listeners", (Throwable)t);
        }
        this.m_radio.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)this.m_radio);
        this.add((Component)new Submit("apply_wf", "Apply Workflow"));
    }

    private class ProcessListener
    implements FormProcessListener {
        private ProcessListener() {
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            BigDecimal flowID = (BigDecimal)ItemWorkflowSelectForm.this.m_radio.getValue(state);
            BigDecimal itemID = CMS.getContext().getContentItem().getID();
            if (Workflow.getObjectWorkflowID((BigDecimal)itemID) == null) {
                WorkflowTemplate template = new WorkflowTemplate(flowID);
                Workflow flow = template.instantiateNewWorkflow();
                flow.setObjectID(itemID);
                flow.start(Web.getContext().getUser());
                flow.save();
            }
        }
    }
}

