/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.cms.ui.workflow.BaseTaskForm;
import com.arsdigita.cms.ui.workflow.WorkflowRequestLocal;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.cms.workflow.CMSTaskType;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.workflow.simple.Task;
import com.arsdigita.workflow.simple.TaskCollection;
import com.arsdigita.workflow.simple.Workflow;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

class TaskAddForm
extends BaseTaskForm {
    private static final Logger s_log = Logger.getLogger(TaskAddForm.class);
    protected static final String ERROR_MSG = "A workflow template with that name already exists in this content section.";
    private final SingleSelectionModel m_model;

    public TaskAddForm(WorkflowRequestLocal workflow, SingleSelectionModel model) {
        super("task", TaskAddForm.gz("cms.ui.workflow.task.add"), workflow);
        this.m_model = model;
        try {
            this.m_deps.addPrintListener((PrintListener)new DependencyPrinter());
        }
        catch (TooManyListenersException tmle) {
            throw new UncheckedWrapperException((Throwable)tmle);
        }
        this.addProcessListener(new ProcessListener());
    }

    private class ProcessListener
    implements FormProcessListener {
        private ProcessListener() {
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            Workflow workflow = TaskAddForm.this.m_workflow.getWorkflow(state);
            CMSTask task = new CMSTask();
            task.setLabel((String)TaskAddForm.this.m_name.getValue(state));
            task.setDescription((String)TaskAddForm.this.m_description.getValue(state));
            task.setTaskType(CMSTaskType.retrieve((Integer)TaskAddForm.this.m_type.getValue(state)));
            task.setActive(true);
            task.save();
            workflow.save();
            workflow.addTask((Task)task);
            TaskAddForm.this.processDependencies((Task)task, (String[])TaskAddForm.this.m_deps.getValue(state));
            task.save();
            TaskAddForm.this.m_model.setSelectedKey(state, (Object)task.getID().toString());
        }
    }

    private class DependencyPrinter
    implements PrintListener {
        private DependencyPrinter() {
        }

        public final void prepare(PrintEvent e) {
            PageState state = e.getPageState();
            TaskCollection tasks = TaskAddForm.this.m_workflow.getWorkflow(state).getTaskCollection();
            OptionGroup options = (OptionGroup)e.getTarget();
            while (tasks.next()) {
                Task task = tasks.getTask();
                options.addOption(new Option(task.getID().toString(), task.getLabel()));
            }
        }
    }
}

