/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.cms.ui.workflow.WorkflowRequestLocal;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Graph;
import com.arsdigita.util.GraphSet;
import com.arsdigita.util.Graphs;
import com.arsdigita.workflow.simple.Task;
import com.arsdigita.workflow.simple.TaskCollection;
import com.arsdigita.workflow.simple.Workflow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class TaskTableModelBuilder
extends AbstractTableModelBuilder {
    private static final Logger s_log = Logger.getLogger(TaskTableModelBuilder.class);
    private final WorkflowRequestLocal m_workflow;

    TaskTableModelBuilder(WorkflowRequestLocal workflow) {
        this.m_workflow = workflow;
    }

    public final TableModel makeModel(Table table, PageState state) {
        s_log.debug((Object)"Creating a new table model for the current request");
        return new Model(this.m_workflow.getWorkflow(state));
    }

    private static class Model
    implements TableModel {
        private Task m_task;
        private Iterator m_tasks;
        private Map m_dependencies = new HashMap();

        private Model(Workflow workflow) {
            TaskCollection tc = workflow.getTaskCollection();
            GraphSet g = new GraphSet();
            while (tc.next()) {
                Task t = tc.getTask();
                TaskCollection deps = t.getRequiredTasks();
                StringBuffer buffer = new StringBuffer();
                while (deps.next()) {
                    Task dep = deps.getTask();
                    g.addEdge((Object)t, (Object)dep, null);
                    buffer.append(dep.getLabel() + ", ");
                }
                int len = buffer.length();
                if (len >= 2) {
                    buffer.setLength(len - 2);
                } else {
                    g.addNode((Object)t);
                }
                deps.close();
                this.m_dependencies.put(t, buffer.toString());
            }
            ArrayList<Task> tasks = new ArrayList<Task>();
            while (g.nodeCount() > 0) {
                List l = Graphs.getSinkNodes((Graph)g);
                Iterator it = l.iterator();
                if (it.hasNext()) {
                    Task t = (Task)it.next();
                    tasks.add(t);
                    g.removeNode((Object)t);
                    continue;
                }
                s_log.error((Object)("found possible loop in tasks for " + workflow));
                break;
            }
            Assert.assertEquals((int)workflow.getTaskCount(), (int)tasks.size());
            this.m_tasks = tasks.iterator();
        }

        public final int getColumnCount() {
            return 4;
        }

        public final boolean nextRow() {
            if (this.m_tasks.hasNext()) {
                this.m_task = (Task)this.m_tasks.next();
                return true;
            }
            return false;
        }

        public final Object getKeyAt(int column) {
            return this.m_task.getID();
        }

        public final Object getElementAt(int column) {
            switch (column) {
                case 0: {
                    return this.m_task.getLabel();
                }
                case 1: {
                    return this.m_task.getDescription();
                }
                case 2: {
                    return this.m_dependencies.get(this.m_task);
                }
                case 3: {
                    return this.m_task.getStateString();
                }
            }
            throw new IllegalStateException();
        }
    }
}

