/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ui.workflow.BaseWorkflowForm;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import org.apache.log4j.Logger;

class WorkflowAddForm
extends BaseWorkflowForm {
    private static final Logger s_log = Logger.getLogger(WorkflowAddForm.class);
    private final SingleSelectionModel m_model;

    WorkflowAddForm(SingleSelectionModel model) {
        super("workflow", WorkflowAddForm.gz("cms.ui.workflow.add"));
        this.m_model = model;
        this.addProcessListener(new ProcessListener());
    }

    private class ProcessListener
    implements FormProcessListener {
        private ProcessListener() {
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            String label = (String)WorkflowAddForm.this.m_title.getValue(state);
            String description = (String)WorkflowAddForm.this.m_description.getValue(state);
            WorkflowTemplate workflow = new WorkflowTemplate();
            workflow.setLabel(label);
            workflow.setDescription(description);
            workflow.save();
            ContentSection section = CMS.getContext().getContentSection();
            section.addWorkflowTemplate(workflow);
            section.save();
            WorkflowAddForm.this.m_model.setSelectedKey(state, (Object)workflow.getID());
        }
    }
}

