/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.cms.ui.BaseAdminPane;
import com.arsdigita.cms.ui.BaseDeleteForm;
import com.arsdigita.cms.ui.VisibilityComponent;
import com.arsdigita.cms.ui.workflow.WorkflowAddForm;
import com.arsdigita.cms.ui.workflow.WorkflowEditForm;
import com.arsdigita.cms.ui.workflow.WorkflowItemPane;
import com.arsdigita.cms.ui.workflow.WorkflowListModelBuilder;
import com.arsdigita.cms.ui.workflow.WorkflowRequestLocal;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public final class WorkflowAdminPane
extends BaseAdminPane {
    private static final Logger s_log = Logger.getLogger(WorkflowAdminPane.class);
    private final WorkflowRequestLocal m_workflow = new SelectionRequestLocal();

    public WorkflowAdminPane() {
        super(WorkflowAdminPane.gz("cms.ui.workflows"), (ListModelBuilder)new WorkflowListModelBuilder());
        this.setAdd(WorkflowAdminPane.gz("cms.ui.workflow.add"), new WorkflowAddForm(this.getSelectionModel()));
        this.setEdit(WorkflowAdminPane.gz("cms.ui.workflow.edit"), new WorkflowEditForm(this.m_workflow));
        this.setDelete(WorkflowAdminPane.gz("cms.ui.workflow.delete"), new DeleteForm());
        this.setIntroPane((Component)new Label(WorkflowAdminPane.gz("cms.ui.workflow.intro")));
        this.setItemPane((Component)new WorkflowItemPane(this.m_workflow, this.getEditLink(), this.getDeleteLink()));
        this.addAction((Component)new VisibilityComponent((Component)this.getAddLink(), "workflow_admin"));
    }

    private class SelectionRequestLocal
    extends WorkflowRequestLocal {
        private SelectionRequestLocal() {
        }

        protected final Object initialValue(PageState state) {
            String id = WorkflowAdminPane.this.getSelectionModel().getSelectedKey(state).toString();
            return new WorkflowTemplate(new BigDecimal(id));
        }
    }

    private class DeleteForm
    extends BaseDeleteForm {
        DeleteForm() {
            super(DeleteForm.gz("cms.ui.workflow.delete_prompt"));
            this.addSecurityListener("workflow_admin");
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            WorkflowAdminPane.this.m_workflow.getWorkflow(state).delete();
            WorkflowAdminPane.this.getSelectionModel().clearSelection(state);
        }
    }
}

