/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.upgrade;

import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeCollection;
import com.arsdigita.cms.contenttypes.XMLContentTypeHandler;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.util.cmd.Program;
import com.arsdigita.xml.XML;
import java.math.BigDecimal;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.log4j.Logger;
import org.xml.sax.helpers.DefaultHandler;

public class CreateGenericContentTypes
extends Program {
    private static Logger s_log = Logger.getLogger(CreateGenericContentTypes.class);

    public CreateGenericContentTypes() {
        super("CreateGenericContentTypes", "1.0.0", "");
    }

    public static final void main(String[] args) {
        new CreateGenericContentTypes().run(args);
    }

    public void doRun(CommandLine cmdLine) {
        new KernelExcursion(){

            public void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                Session session = SessionManager.getSession();
                TransactionContext tc = session.getTransactionContext();
                tc.beginTxn();
                String[] ctDefFiles = new String[]{"/WEB-INF/content-types/GenericAddress.xml", "/WEB-INF/content-types/GenericArticle.xml", "/WEB-INF/content-types/GenericContact.xml", "/WEB-INF/content-types/GenericOrganizationalUnit.xml", "/WEB-INF/content-types/GenericPerson.xml"};
                if (ctDefFiles != null) {
                    for (int i = 0; i < ctDefFiles.length; ++i) {
                        String xmlFile = ctDefFiles[i];
                        s_log.debug((Object)("Processing contentTypes in: " + xmlFile));
                        XML.parseResource((String)xmlFile, (DefaultHandler)new XMLContentTypeHandler());
                    }
                }
                tc.commitTxn();
                tc.beginTxn();
                ContentTypeCollection ctc = ContentType.getAllContentTypes();
                s_log.debug((Object)"Starte content types update");
                while (ctc.next()) {
                    ContentType ct = ctc.getContentType();
                    s_log.debug((Object)("Verarbeite " + ct.getClassName()));
                    CreateGenericContentTypes.this.createPedigree(ct);
                }
                tc.commitTxn();
            }
        }.run();
    }

    private void createPedigree(ContentType type) {
        ContentType parent = null;
        ContentTypeCollection cts = ContentType.getAllContentTypes();
        while (cts.next()) {
            ContentType ct = cts.getContentType();
            try {
                Class.forName(type.getClassName()).asSubclass(Class.forName(ct.getClassName()));
            }
            catch (Exception ex) {
                continue;
            }
            if (type.getClassName().equals(ct.getClassName()) || parent != null && (parent.getAncestors() == null || ct.getAncestors() == null || parent.getAncestors().length() >= ct.getAncestors().length())) continue;
            parent = ct;
        }
        if (parent != null && !parent.getClassName().equals(type.getClassName())) {
            if (parent.getAncestors() != null) {
                String parentAncestors = parent.getAncestors();
                StringTokenizer strTok = new StringTokenizer(parentAncestors, "/");
                while (strTok.hasMoreElements()) {
                    BigDecimal ctID = new BigDecimal(strTok.nextToken());
                    try {
                        ContentType ct = new ContentType(ctID);
                        ct.addDescendants(ctID);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    type.addAncestor(ctID);
                }
            }
            type.addAncestor(parent.getID());
            parent.addDescendants(type.getID());
        }
    }
}

