/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.util;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Pair;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class LanguageUtil {
    private static Logger s_log = Logger.getLogger(LanguageUtil.class);
    private static String s_languages = null;
    private static String[] s_languagesArray = null;
    private static final String ISO639_2LA_3LA = "com.arsdigita.cms.util.iso639rev";
    private static ResourceBundle s_lang3LA = ResourceBundle.getBundle("com.arsdigita.cms.util.iso639rev");
    private static final String ISO639_2LA_FULL = "com.arsdigita.cms.util.iso639full";
    private static ResourceBundle s_langFull = ResourceBundle.getBundle("com.arsdigita.cms.util.iso639full");

    public static GlobalizedMessage globalize(String key) {
        return new LanguageGlobalizedMessage(key);
    }

    public static void setSupportedLanguages(String languages) {
        s_languages = Kernel.getConfig().languageIndependentItems() && languages.indexOf(GlobalizationHelper.LANG_INDEPENDENT) >= 0 ? languages.replace(" ", "").trim() + "," + GlobalizationHelper.LANG_INDEPENDENT : languages.replace(" ", "").trim();
    }

    public static String getSupportedLanguages() {
        Assert.exists((Object)s_languages, (String)"supported languages not set");
        return s_languages;
    }

    public static Collection getSupportedLanguages2LA() {
        String allLanguages = LanguageUtil.getSupportedLanguages();
        StringTokenizer tokenizer = new StringTokenizer(allLanguages, ",");
        LinkedList<String> langList = new LinkedList<String>();
        while (tokenizer.hasMoreElements()) {
            String language = tokenizer.nextToken();
            langList.add(language);
        }
        return langList;
    }

    public static Collection getSupportedLanguages3LA() {
        String allLanguages = LanguageUtil.getSupportedLanguages();
        StringTokenizer tokenizer = new StringTokenizer(allLanguages, ",");
        LinkedList<Pair> langList = new LinkedList<Pair>();
        while (tokenizer.hasMoreElements()) {
            String language = tokenizer.nextToken();
            langList.add(new Pair((Object)language, (Object)LanguageUtil.getLang3LA(language)));
        }
        return langList;
    }

    public static Collection getSupportedLanguagesFull() {
        String allLanguages = LanguageUtil.getSupportedLanguages();
        StringTokenizer tokenizer = new StringTokenizer(allLanguages, ",");
        LinkedList<Pair> langList = new LinkedList<Pair>();
        while (tokenizer.hasMoreElements()) {
            String language = tokenizer.nextToken();
            langList.add(new Pair((Object)language, (Object)LanguageUtil.getLangFull(language)));
        }
        return langList;
    }

    public static Collection getCreatableLanguages(ContentPage item) {
        ContentBundle bundle = item.getContentBundle();
        Collection allList = LanguageUtil.getSupportedLanguages2LA();
        allList.removeAll(bundle.getLanguages());
        return allList;
    }

    public static String getLang3LA(String lang) {
        String threeLA;
        try {
            threeLA = new Locale(lang).getISO3Language();
        }
        catch (MissingResourceException mre) {
            try {
                threeLA = s_lang3LA.getString(lang);
            }
            catch (MissingResourceException mexc) {
                s_log.warn((Object)("Three letter language code for key '" + lang + "' not found: " + mexc));
                threeLA = lang;
            }
        }
        return threeLA;
    }

    public static String getLangFull(String lang) {
        String fullName = new Locale(lang).getDisplayLanguage(GlobalizationHelper.getNegotiatedLocale());
        if (lang.equals(fullName)) {
            try {
                fullName = s_langFull.getString(lang);
            }
            catch (MissingResourceException mexc) {
                s_log.warn((Object)("Full  language name for key '" + lang + "' not found " + mexc));
                fullName = lang;
            }
        }
        return fullName;
    }

    public static Collection convertTo3LA(Collection list) {
        LinkedList<Pair> conList = new LinkedList<Pair>();
        for (String lang2Code : list) {
            conList.add(new Pair((Object)lang2Code, (Object)LanguageUtil.getLang3LA(lang2Code)));
        }
        return conList;
    }

    public static Collection convertToFull(Collection list) {
        LinkedList<Pair> conList = new LinkedList<Pair>();
        for (String lang2Code : list) {
            conList.add(new Pair((Object)lang2Code, (Object)LanguageUtil.getLangFull(lang2Code)));
        }
        return conList;
    }

    public static Collection convertToG11N(Collection list) {
        LinkedList<Pair> conList = new LinkedList<Pair>();
        for (String lang2Code : list) {
            conList.add(new Pair((Object)lang2Code, (Object)LanguageUtil.globalize(lang2Code)));
        }
        return conList;
    }

    private static class LanguageGlobalizedMessage
    extends GlobalizedMessage {
        public LanguageGlobalizedMessage(String key) {
            super(key);
        }

        public Object localize(Locale locale) {
            return LanguageUtil.getLangFull(this.getKey());
        }
    }
}

