/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.workflow;

import com.arsdigita.cms.Folder;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.cmd.Program;
import java.math.BigDecimal;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class AddApprovePermission
extends Program {
    private static final Logger s_log = Logger.getLogger(AddApprovePermission.class);

    public AddApprovePermission() {
        super("AddApprovePermission", "1.0.0", "");
        Options options = this.getOptions();
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)"group-id");
        OptionBuilder.withDescription((String)"Grant approve item privilege to folders where this group has edit privilege");
        options.addOption(OptionBuilder.create((char)'g'));
    }

    public void doRun(CommandLine cmdLine) {
        BigDecimal groupID = new BigDecimal(cmdLine.getOptionValue("g"));
        try {
            SessionManager.getSession().getTransactionContext().beginTxn();
            Group group = new Group(groupID);
            DataCollection folders = SessionManager.getSession().retrieve("com.arsdigita.cms.Folder");
            PermissionService.filterObjects((DataCollection)folders, (PrivilegeDescriptor)PrivilegeDescriptor.get((String)"cms_edit_item"), (OID)new OID("com.arsdigita.kernel.Group", (Object)groupID));
            while (folders.next()) {
                Folder folder = (Folder)DomainObjectFactory.newInstance((DataObject)folders.getDataObject());
                PermissionDescriptor approve = new PermissionDescriptor(PrivilegeDescriptor.get((String)"cms_approve_item"), (ACSObject)folder, (Party)group);
                PermissionService.grantPermission((PermissionDescriptor)approve);
            }
            SessionManager.getSession().getTransactionContext().commitTxn();
        }
        catch (Exception e) {
            s_log.error((Object)("Failed to grant permissions for group " + groupID), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        new AddApprovePermission().run(args);
    }
}

