/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.workflow;

import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.workflow.simple.Engine;
import com.arsdigita.workflow.simple.Workflow;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class CMSEngine
extends Engine {
    public static final String CMS_ENGINE_TYPE = "cms";
    private static final Logger s_log = Logger.getLogger(CMSEngine.class);

    public List getEnabledTasks(User user, BigDecimal workflowID) {
        s_log.debug((Object)"getEnabledTasks");
        DataCollection tasks = SessionManager.getSession().retrieve("com.arsdigita.cms.workflow.CMSTask");
        tasks.addPath("taskWf.object");
        tasks.addPath("taskType");
        tasks.addEqualsFilter("parentTaskID", (Object)workflowID);
        tasks.addEqualsFilter("isActive", (Object)Boolean.TRUE);
        tasks.addEqualsFilter("taskState", (Object)"enabled");
        Filter assignedToUser = tasks.getFilterFactory().equals("assignedUsers.id", (Object)user.getID());
        Filter assignedToUserGroup = tasks.getFilterFactory().equals("assignedGroups.allMembers.id", (Object)user.getID());
        tasks.addFilter((Filter)tasks.getFilterFactory().or().addFilter(assignedToUser).addFilter(assignedToUserGroup));
        HashSet<OID> userTasks = new HashSet<OID>();
        while (tasks.next()) {
            userTasks.add(tasks.getDataObject().getOID());
        }
        Iterator it = userTasks.iterator();
        ArrayList<CMSTask> accessibleUserTasks = new ArrayList<CMSTask>();
        while (it.hasNext()) {
            CMSTask task = (CMSTask)DomainObjectFactory.newInstance((OID)((OID)it.next()));
            s_log.debug((Object)("task retrieved is " + task.getID()));
            Workflow workflow = task.getWorkflow();
            s_log.debug((Object)("workflow for task is " + workflow.getID()));
            ACSObject object = workflow.getObject();
            PrivilegeDescriptor privilege = task.getTaskType().getPrivilege();
            PermissionDescriptor taskAccess = new PermissionDescriptor(privilege, object, (Party)user);
            s_log.debug((Object)("checking " + privilege.getName() + " privilege on object " + object.getID()));
            if (!PermissionService.checkPermission((PermissionDescriptor)taskAccess)) continue;
            s_log.debug((Object)("user " + user.getID() + " can access this task"));
            accessibleUserTasks.add(task);
        }
        return accessibleUserTasks;
    }
}

