/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.workflow;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.cms.workflow.CMSTaskType;
import com.arsdigita.cms.workflow.TaskURLGenerator;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.messaging.Message;
import com.arsdigita.notification.Notification;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.Assert;
import com.arsdigita.versioning.TagCollection;
import com.arsdigita.versioning.Transaction;
import com.arsdigita.versioning.TransactionCollection;
import com.arsdigita.versioning.Versions;
import com.arsdigita.web.URL;
import com.arsdigita.workflow.simple.TaskComment;
import com.arsdigita.workflow.simple.TaskException;
import com.arsdigita.workflow.simple.UserTask;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CMSTask
extends UserTask {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.workflow.CMSTask";
    public static final String TASK_TYPE = "taskType";
    private static Map s_taskURLGeneratorCache = new HashMap();
    public static final String UNFINISHED_OP = "unfinished";
    private static final Map s_alerts = new HashMap(5);
    private static final String ALERT_OPERATIONS = "operations";
    private static final String ALERT_RECIPIENTS = "recipients";
    private static final String ALERT_RECIPIENT_ALL = "_ALL";
    private static final String ALERT_RECIPIENT_LASTAUTHOR = "_LASTAUTHOR";
    private static final Logger s_log = Logger.getLogger(CMSTask.class);
    private boolean m_authorOnly = false;

    public CMSTask() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    protected CMSTask(ObjectType type) {
        super(type);
    }

    protected CMSTask(String typeName) {
        super(typeName);
    }

    public CMSTask(DataObject CMSTaskObject) {
        super(CMSTaskObject);
    }

    public CMSTask(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public CMSTask(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected void initialize() {
        super.initialize();
        if (this.isNew()) {
            this.setTaskType(CMSTaskType.retrieve(CMSTaskType.AUTHOR));
        }
    }

    public void setTaskType(CMSTaskType taskType) {
        this.setAssociation(TASK_TYPE, taskType);
    }

    public CMSTaskType getTaskType() {
        return new CMSTaskType((DataObject)this.get(TASK_TYPE));
    }

    public String getFinishURL(BigDecimal itemId) {
        if (itemId == null) {
            return "";
        }
        TaskURLGenerator generator = this.getURLGenerator(this.getTaskType().getID());
        return generator.generateURL(itemId, this.getID());
    }

    protected String getAuthoringURL(ContentItem item) {
        return ContentItemPage.getItemURL(item, ContentItemPage.AUTHORING_TAB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentItem getItem() {
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.workflow.getItemFromTask");
        query.setParameter("taskID", (Object)this.getID());
        try {
            if (query.next()) {
                DataObject obj = (DataObject)query.get("obj");
                ContentItem contentItem = (ContentItem)DomainObjectFactory.newInstance((DataObject)obj);
                return contentItem;
            }
            ContentItem contentItem = null;
            return contentItem;
        }
        finally {
            query.close();
        }
    }

    public void enableEvt() {
        super.enableEvt();
        DataOperation oper = SessionManager.getSession().retrieveDataOperation("com.arsdigita.cms.workflow.clearNotifications");
        oper.setParameter("taskID", (Object)this.getID());
        oper.execute();
    }

    private TaskURLGenerator getURLGenerator(Integer taskTypeID) {
        TaskURLGenerator t = (TaskURLGenerator)s_taskURLGeneratorCache.get(taskTypeID);
        if (t == null) {
            Session s = SessionManager.getSession();
            DataQuery query = s.retrieveQuery("com.arsdigita.cms.workflow.getTaskTypes");
            query.addEqualsFilter("Id", (Object)taskTypeID);
            if (query.next()) {
                String className = (String)query.get("className");
                query.close();
                try {
                    Class<?> URLGenerator = Class.forName(className);
                    t = (TaskURLGenerator)URLGenerator.newInstance();
                    s_taskURLGeneratorCache.put(taskTypeID, t);
                }
                catch (ClassNotFoundException c) {
                    s_log.error((Object)"Couldn't find class", (Throwable)c);
                }
                catch (IllegalAccessException i) {
                    s_log.error((Object)"Couldn't access constructor or newInstance", (Throwable)i);
                }
                catch (InstantiationException n) {
                    s_log.error((Object)"Couldn't instantiate", (Throwable)n);
                }
            }
        }
        return t;
    }

    protected Message generateMessage(String operation, Party sender) {
        ContentItem item = this.getItem();
        Assert.exists((Object)item, (String)"item associated with this CMSTask");
        String authoringURL = this.getAuthoringURL(item);
        String fullURL = this.getTaskType().getURLGenerator(operation, item).generateURL(item.getID(), this.getID());
        s_log.debug((Object)("URL retrieved from generator: " + fullURL));
        if (!fullURL.startsWith("http")) {
            fullURL = URL.there((String)fullURL, null).getURL();
        }
        Object[] g11nArgs = new Object[11];
        g11nArgs[0] = item.getDisplayName();
        g11nArgs[1] = new Double(this.getTaskType().getID().doubleValue());
        g11nArgs[2] = fullURL;
        g11nArgs[3] = KernelHelper.getSiteName();
        g11nArgs[4] = KernelHelper.getSystemAdministratorEmailAddress();
        g11nArgs[5] = new Date();
        TaskComment comment = this.getLastCommentInWorkflow();
        User commenter = null;
        if (comment != null) {
            commenter = comment.getUser();
            g11nArgs[6] = comment.getComment();
        } else {
            g11nArgs[6] = "";
        }
        g11nArgs[7] = commenter != null ? commenter.getName() : (String)GlobalizationUtil.globalize("cms.ui.unknown").localize();
        g11nArgs[8] = this.getStartDate();
        g11nArgs[9] = URL.there((String)authoringURL, null).getURL();
        g11nArgs[10] = ((ContentItem)item.getParent()).getPath();
        String subject = (String)GlobalizationUtil.globalize("cms.ui.workflow.email.subject." + operation, g11nArgs).localize();
        String body = (String)GlobalizationUtil.globalize("cms.ui.workflow.email.body." + operation, g11nArgs).localize();
        Message msg = new Message(sender, subject, body);
        msg.save();
        return msg;
    }

    public Object clone() {
        CMSTask taskClone = new CMSTask();
        this.copyAttributes(taskClone);
        return taskClone;
    }

    protected void copyAttributes(CMSTask task) {
        super.copyAttributes((UserTask)task);
        task.setTaskType(this.getTaskType());
    }

    public ContentSection getContentSection() {
        ContentItem item = this.getItem();
        if (item != null) {
            return item.getContentSection();
        }
        return null;
    }

    protected void sendUnfinishedNotification() {
        Party sender = this.getNotificationSender();
        if (sender != null) {
            Message msg = this.generateMessage(UNFINISHED_OP, sender);
            this.m_authorOnly = false;
            this.sendMessageToAssignees(msg);
        }
    }

    public static void addAlert(ContentSection section, String typeLabel, String operation) {
        HashSet<String> authorOnlySet;
        HashSet<String> operationSet;
        HashMap operations;
        if (section == null || typeLabel == null || operation == null) {
            return;
        }
        typeLabel = typeLabel.trim();
        operation = operation.trim();
        HashMap typeMap = (HashMap)s_alerts.get(section.getID());
        if (typeMap == null) {
            typeMap = new HashMap(5);
            s_alerts.put(section.getID(), typeMap);
        }
        if ((operations = (HashMap)typeMap.get(typeLabel)) == null) {
            operations = new HashMap(2);
            typeMap.put(typeLabel, operations);
        }
        if ((operationSet = (HashSet<String>)operations.get(ALERT_OPERATIONS)) == null) {
            operationSet = new HashSet<String>(5);
            operations.put(ALERT_OPERATIONS, operationSet);
        }
        if ((authorOnlySet = (HashSet<String>)operations.get(ALERT_RECIPIENTS)) == null) {
            authorOnlySet = new HashSet<String>(5);
            operations.put(ALERT_RECIPIENTS, authorOnlySet);
        }
        String recipients = ALERT_RECIPIENT_ALL;
        if (operation.endsWith(ALERT_RECIPIENT_LASTAUTHOR)) {
            operation = operation.substring(0, operation.length() - ALERT_RECIPIENT_LASTAUTHOR.length());
            authorOnlySet.add(operation);
            recipients = ALERT_RECIPIENT_LASTAUTHOR;
        } else if (operation.endsWith(ALERT_RECIPIENT_ALL)) {
            operation = operation.substring(0, operation.length() - ALERT_RECIPIENT_ALL.length());
        }
        operationSet.add(operation);
        s_log.info((Object)("Added alert for \"" + operation + "\" of " + typeLabel + " task in section \"" + section.getName() + "\" recipients flag: " + recipients));
    }

    protected static boolean shouldSendAlert(ContentSection section, String typeLabel, String operation) {
        return CMSTask.checkAlertsConfig(section, typeLabel, operation, ALERT_OPERATIONS);
    }

    protected static boolean shouldSendToAuthorOnly(ContentSection section, String typeLabel, String operation) {
        return CMSTask.checkAlertsConfig(section, typeLabel, operation, ALERT_RECIPIENTS);
    }

    private static boolean checkAlertsConfig(ContentSection section, String typeLabel, String operation, String field) {
        Map operations;
        if (section == null || typeLabel == null || operation == null) {
            return false;
        }
        typeLabel = typeLabel.trim();
        operation = operation.trim();
        boolean send = false;
        Map typeMap = (Map)s_alerts.get(section.getID());
        Set operationSet = null;
        if (typeMap != null && (operations = (Map)typeMap.get(typeLabel)) != null) {
            operationSet = (Set)operations.get(field);
        }
        if (operationSet != null) {
            send = operationSet.contains(operation);
        }
        s_log.debug((Object)("operation " + operation + " field " + field + " of task " + typeLabel + "?: " + send));
        return send;
    }

    protected boolean sendAlerts(String operation) {
        ContentSection section = this.getContentSection();
        String label = this.getLabel();
        this.m_authorOnly = CMSTask.shouldSendToAuthorOnly(section, label, operation);
        return super.sendAlerts(operation) && CMSTask.shouldSendAlert(section, label, operation);
    }

    protected void sendMessageToAssignees(Message msg) {
        if (this.m_authorOnly) {
            ContentItem item = this.getItem();
            User author = null;
            TransactionCollection hist = Versions.getTaggedTransactions((OID)item.getOID());
            while (author == null && hist.next()) {
                Transaction txn = hist.getTransaction();
                TagCollection tags = txn.getTags();
                while (tags.next()) {
                    String tag = tags.getTag().getDescription();
                    if (!"Authored".equals(tag)) continue;
                    author = txn.getUser();
                    if (!s_log.isDebugEnabled()) continue;
                    s_log.debug((Object)("author from hist=" + author + " at " + txn.getTimestamp()));
                }
            }
            hist.close();
            if (author == null) {
                author = item.getCreationUser();
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("spamming ONLY author " + author));
            }
            Notification notification = new Notification((Party)author, msg);
            if (ContentSection.getConfig().deleteWorkflowNotifications()) {
                notification.setIsPermanent(Boolean.FALSE);
                notification.setMessageDelete(Boolean.TRUE);
            }
            notification.save();
            return;
        }
        UserCollection uc = null;
        uc = new UserCollection((DataCollection)this.getAssignedUserAssociation().cursor());
        s_log.debug((Object)"spamming users...");
        this.filterUsersAndSendMessage(uc, msg);
        Iterator itr = this.getAssignedGroups();
        ArrayList<BigDecimal> groups = new ArrayList<BigDecimal>();
        Group tmpGroup = null;
        while (itr.hasNext()) {
            tmpGroup = (Group)itr.next();
            groups.add(tmpGroup.getID());
        }
        s_log.debug((Object)"spamming groups...");
        if (groups.size() > 0) {
            uc = User.retrieveAll();
            uc.addFilter("allGroups in :assignedGroups").set("assignedGroups", groups);
            this.filterUsersAndSendMessage(uc, msg);
        }
    }

    protected void filterUsersAndSendMessage(UserCollection uc, Message msg) {
        CMSTaskType type = this.getTaskType();
        PrivilegeDescriptor pd = type.getPrivilege();
        Filter pFilter = PermissionService.getObjectFilterQuery((FilterFactory)uc.getFilterFactory(), (String)"id", (PrivilegeDescriptor)pd, (OID)this.getItem().getOID());
        uc.addFilter(pFilter);
        Notification notification = null;
        HashSet<User> spamVictims = new HashSet<User>();
        while (uc.next()) {
            spamVictims.add(uc.getUser());
        }
        for (User user : spamVictims) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("spamming user " + user));
            }
            notification = new Notification((Party)user, msg);
            if (ContentSection.getConfig().deleteWorkflowNotifications()) {
                notification.setIsPermanent(Boolean.FALSE);
                notification.setMessageDelete(Boolean.TRUE);
            }
            notification.save();
        }
    }

    public void finish() throws TaskException {
        super.finish();
        Integer type = this.getTaskType().getID();
        ContentItem item = this.getItem();
        if (type.equals(CMSTaskType.AUTHOR)) {
            item.applyTag("Authored");
        } else if (type.equals(CMSTaskType.EDIT)) {
            item.applyTag("Edited");
        } else if (type.equals(CMSTaskType.DEPLOY)) {
            item.applyTag("Deployed");
        } else {
            throw new IllegalStateException("unknown task type: " + type);
        }
    }
}

