/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.workflow;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.workflow.TaskEventURLGenerator;
import com.arsdigita.cms.workflow.TaskURLGenerator;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CMSTaskType
extends DomainObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.workflow.CMSTaskType";
    private static Map s_taskURLGeneratorCache = new HashMap();
    public static final String ID = "taskTypeID";
    public static final String NAME = "name";
    public static final String DEFAULT_URL_GENERATOR_CLASS = "defaultUrlGeneratorClass";
    public static final String PRIVILEGE = "privilege";
    public static final String URL_GENERATORS = "generators";
    private static final Logger s_log = Logger.getLogger(CMSTaskType.class);
    public static final Integer AUTHOR = new Integer(1);
    public static final Integer EDIT = new Integer(2);
    public static final Integer DEPLOY = new Integer(3);
    public static Map<Integer, CMSTaskType> s_taskTypes = new HashMap<Integer, CMSTaskType>();
    private static Map<String, Integer> s_taskNameMap = new HashMap<String, Integer>();

    public static CMSTaskType retrieve(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter id must not be null");
        }
        CMSTaskType type = s_taskTypes.get(id);
        if (type == null) {
            type = new CMSTaskType(id);
            s_taskTypes.put(id, type);
        }
        return type;
    }

    public static CMSTaskType retrieveByName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Parameter name must not be null or empty");
        }
        Integer id = s_taskNameMap.get(name);
        if (id == null) {
            for (CMSTaskType type : s_taskTypes.values()) {
                if (!s_taskNameMap.containsKey(type.getName())) {
                    s_taskNameMap.put(type.getName(), type.getID());
                }
                if (!name.equals(type.getName())) continue;
                id = type.getID();
            }
        }
        return CMSTaskType.retrieve(id);
    }

    private CMSTaskType(Integer id) {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public CMSTaskType(DataObject obj) {
        super(obj);
    }

    public CMSTaskType() {
        super(BASE_DATA_OBJECT_TYPE);
        this.setID();
    }

    public Integer getID() {
        return (Integer)this.get(ID);
    }

    private void setID() {
        DataCollection allTypes = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        allTypes.addOrder("taskTypeID desc");
        Integer id = new Integer(1);
        if (allTypes.next()) {
            CMSTaskType taskType = (CMSTaskType)DomainObjectFactory.newInstance((DataObject)allTypes.getDataObject());
            int currentMaxID = taskType.getID();
            id = new Integer(currentMaxID + 1);
            allTypes.close();
        }
        this.set(ID, id);
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public PrivilegeDescriptor getPrivilege() {
        return PrivilegeDescriptor.get((String)((String)this.get(PRIVILEGE)));
    }

    private TaskURLGenerator getDefaultTaskURLGenerator() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String generatorClassName = (String)this.get(DEFAULT_URL_GENERATOR_CLASS);
        Class<?> URLGenerator = Class.forName(generatorClassName);
        return (TaskURLGenerator)URLGenerator.newInstance();
    }

    public TaskURLGenerator getURLGenerator(String event, ContentItem item) {
        String key = this.getID() + " " + event + " " + item.getContentType().getID();
        s_log.debug((Object)("looking up url generator for key " + key));
        TaskURLGenerator generator = (TaskURLGenerator)s_taskURLGeneratorCache.get(key);
        if (generator == null) {
            s_log.debug((Object)"no generator found in cache");
            DataAssociationCursor generators = ((DataAssociation)this.get(URL_GENERATORS)).cursor();
            generators.addEqualsFilter("event", (Object)event);
            generators.addEqualsFilter("contentType.id", (Object)item.getContentType().getID());
            try {
                while (generators.next()) {
                    s_log.debug((Object)("specific generator found for " + event + " event on task type " + this.getName() + " for content type " + item.getContentType().getLabel()));
                    generator = ((TaskEventURLGenerator)DomainObjectFactory.newInstance((DataObject)generators.getDataObject())).getGenerator();
                    generators.close();
                }
                if (generator == null) {
                    generators.reset();
                    generators.addEqualsFilter("event", (Object)event);
                    generators.addEqualsFilter("contentType", null);
                    while (generators.next()) {
                        s_log.debug((Object)("specific generator found for " + event + " event on task type " + this.getName() + " for any content type"));
                        generator = ((TaskEventURLGenerator)DomainObjectFactory.newInstance((DataObject)generators.getDataObject())).getGenerator();
                        generators.close();
                    }
                }
                if (generator == null) {
                    s_log.debug((Object)("no specific generator for " + event + " event on task type " + this.getName() + ". Revert to default"));
                    generator = this.getDefaultTaskURLGenerator();
                }
                s_taskURLGeneratorCache.put(key, generator);
            }
            catch (Exception e) {
                throw new UncheckedWrapperException("Unable to retrieve a URL generator for event " + event + " on task type " + this.getID() + " ", (Throwable)e);
            }
        }
        return generator;
    }

    public void clearCachedEntry(String event) {
        String key = this.getID() + " " + event;
        s_taskURLGeneratorCache.remove(key);
    }

    static {
        s_taskNameMap.put("Author", AUTHOR);
        s_taskNameMap.put("Edit", EDIT);
        s_taskNameMap.put("Deploy", DEPLOY);
    }
}

