/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.workflow;

import com.arsdigita.cms.workflow.TaskURLGenerator;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import org.apache.log4j.Logger;

public class TaskEventURLGenerator
extends DomainObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.workflow.TaskEventURLGenerator";
    public static final String ID = "generatorID";
    public static final String EVENT = "event";
    public static final String URL_GENERATOR_CLASS = "urlGeneratorClass";
    public static final String CONTENT_TYPE = "contentType";
    private static final Logger s_log = Logger.getLogger(TaskEventURLGenerator.class);

    public TaskEventURLGenerator(Integer id) {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public TaskEventURLGenerator(DataObject obj) {
        super(obj);
    }

    public TaskEventURLGenerator() {
        super(BASE_DATA_OBJECT_TYPE);
        this.setID();
    }

    public int getID() {
        return (Integer)this.get(ID);
    }

    private void setID() {
        DataCollection allTypes = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        allTypes.addOrder("generatorID desc");
        Integer id = new Integer(1);
        if (allTypes.next()) {
            TaskEventURLGenerator taskType = (TaskEventURLGenerator)DomainObjectFactory.newInstance((DataObject)allTypes.getDataObject());
            int currentMaxID = taskType.getID();
            id = new Integer(currentMaxID + 1);
            allTypes.close();
        }
        this.set(ID, id);
    }

    public TaskURLGenerator getGenerator() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String generatorClassName = (String)this.get(URL_GENERATOR_CLASS);
        Class<?> URLGenerator = Class.forName(generatorClassName);
        return (TaskURLGenerator)URLGenerator.newInstance();
    }
}

