/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.workflow;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.cms.workflow.UnfinishedNotification;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class UnfinishedTaskNotifier
extends TimerTask {
    private static final Logger s_log = Logger.getLogger(UnfinishedTaskNotifier.class);
    private BigDecimal m_sectionID;
    private long m_unfinishedInterval;
    private long m_notificationInterval;
    private int m_maxNotifications;

    public UnfinishedTaskNotifier(ContentSection section, int unfinishedInterval, int notificationInterval, int maxNotifications) {
        Assert.exists((Object)((Object)section), (String)"the ContentSection to send notifications for");
        this.m_sectionID = section.getID();
        this.m_unfinishedInterval = (long)unfinishedInterval * 60L * 60L * 1000L;
        this.m_notificationInterval = (long)notificationInterval * 60L * 60L * 1000L;
        this.m_maxNotifications = maxNotifications;
        s_log.debug((Object)("Created UnfinishedTaskNotifier for section " + section.getName()));
        s_log.debug((Object)("Sending notifications for tasks over " + this.m_unfinishedInterval + " milliseconds old, with repeat notifications every " + this.m_notificationInterval + " milliseconds, with a maxmimum of " + this.m_maxNotifications + " notifications going out for every task."));
    }

    @Override
    public void run() {
        Thread.currentThread().setName("unfinished-notifier");
        try {
            new KernelExcursion(){

                protected final void excurse() {
                    this.setEffectiveParty(Kernel.getSystemParty());
                    UnfinishedTaskNotifier.this.internalRun();
                }
            }.run();
        }
        catch (Throwable t) {
            s_log.error((Object)"Unexpeced error occured in UnfinishedTaskNotifier.Task has been disabled", t);
            throw new UncheckedWrapperException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRun() {
        s_log.debug((Object)"Running UnfinishedTaskNotifier");
        boolean committedTxn = false;
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        long startTime = System.currentTimeMillis();
        try {
            txn.beginTxn();
            DataQuery unfinishedTasks = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.workflow.getUnfinishedTasks");
            unfinishedTasks.setParameter("sectionID", (Object)this.m_sectionID);
            unfinishedTasks.setParameter("overdueDate", (Object)new Date(System.currentTimeMillis() - this.m_unfinishedInterval));
            while (unfinishedTasks.next()) {
                CMSTask task = (CMSTask)DomainObjectFactory.newInstance((DataObject)((DataObject)unfinishedTasks.get("task")));
                UnfinishedNotification notification = UnfinishedNotification.retrieveForTask(task);
                Date lastSentDate = notification.getLastNotificationDate();
                int numSent = notification.getNumNotifications();
                if (lastSentDate != null && !lastSentDate.before(new Date(System.currentTimeMillis() - this.m_notificationInterval)) || this.m_maxNotifications <= numSent) continue;
                s_log.debug((Object)("Sending unfinished notification for " + (Object)((Object)task) + ", started on " + task.getStartDate()));
                notification.incrNumNotifications();
                notification.save();
                task.sendUnfinishedNotification();
            }
            txn.commitTxn();
            committedTxn = true;
            s_log.debug((Object)("UnfinishedTaskNotifier completed in " + (System.currentTimeMillis() - startTime) + "ms"));
        }
        finally {
            if (!committedTxn) {
                txn.abortTxn();
            }
        }
    }
}

