/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.rssfeed;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.rssfeed.FeedCollection;
import java.math.BigDecimal;

public class Feed
extends ACSObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.rssfeed.Feed";
    public static final String TITLE = "title";
    public static final String URL = "url";
    public static final String DESCRIPTION = "description";
    public static final String IS_PROVIDER = "isProvider";

    public Feed() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public Feed(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Feed(DataObject obj) {
        super(obj);
    }

    public Feed(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public static Feed create(String url, String title, String desc, boolean provider) {
        Feed feed = new Feed();
        feed.setURL(url);
        feed.setTitle(title);
        feed.setDescription(desc);
        feed.setProvider(provider);
        return feed;
    }

    public static Feed retrieve(BigDecimal id) throws DataObjectNotFoundException {
        Session session = SessionManager.getSession();
        DataCollection feed = session.retrieve(BASE_DATA_OBJECT_TYPE);
        feed.addEqualsFilter("id", (Object)id);
        if (feed.next()) {
            DataObject obj = feed.getDataObject();
            feed.close();
            return new Feed(obj);
        }
        throw new DataObjectNotFoundException("cannot find feed " + id);
    }

    public static Feed retrieve(String url) throws DataObjectNotFoundException {
        Session session = SessionManager.getSession();
        DataCollection feed = session.retrieve(BASE_DATA_OBJECT_TYPE);
        feed.addEqualsFilter(URL, (Object)url);
        if (feed.next()) {
            DataObject obj = feed.getDataObject();
            feed.close();
            return new Feed(obj);
        }
        throw new DataObjectNotFoundException("cannot find feed" + url);
    }

    public static FeedCollection retrieveAll() {
        Session session = SessionManager.getSession();
        DataCollection feeds = session.retrieve(BASE_DATA_OBJECT_TYPE);
        feeds.addOrder(TITLE);
        return new FeedCollection(feeds);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public void setTitle(String title) {
        this.set(TITLE, title);
    }

    public String getTitle() {
        return (String)this.get(TITLE);
    }

    public void setURL(String url) {
        this.set(URL, url);
    }

    public String getURL() {
        return (String)this.get(URL);
    }

    public void setDescription(String desc) {
        this.set(DESCRIPTION, desc);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setProvider(boolean provider) {
        this.set(IS_PROVIDER, new Boolean(provider));
    }

    public boolean isProvider() {
        return (Boolean)this.get(IS_PROVIDER);
    }
}

