/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.rssfeed.category;

import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryPurpose;
import com.arsdigita.kernel.URLService;
import com.arsdigita.persistence.OID;
import com.arsdigita.rssfeed.RSSChannel;
import com.arsdigita.rssfeed.RSSImage;
import com.arsdigita.rssfeed.RSSItem;
import com.arsdigita.rssfeed.RSSItemCollection;
import com.arsdigita.util.Assert;
import java.util.Collection;
import java.util.Iterator;

public class CategoryPurposeChannel
implements RSSChannel {
    private RSSImage m_image;
    private CategoryPurpose m_purpose;

    public CategoryPurposeChannel(CategoryPurpose purpose, RSSImage image) {
        this.m_image = image;
        this.m_purpose = purpose;
    }

    @Override
    public String getTitle() {
        return this.m_purpose.getName();
    }

    @Override
    public String getLink() {
        return URLService.locate((OID)this.m_purpose.getOID());
    }

    @Override
    public String getDescription() {
        return this.m_purpose.getDescription();
    }

    @Override
    public RSSImage getImage() {
        return this.m_image;
    }

    @Override
    public RSSItemCollection getItems() {
        return new CategoryPurposeItemCollection(this.m_purpose.getCategories());
    }

    private class CategoryPurposeItem
    implements RSSItem {
        private Category m_category;
        private String m_categoryLink;

        public CategoryPurposeItem(Category category) {
            this.m_category = category;
        }

        @Override
        public String getTitle() {
            return this.m_category.getName();
        }

        @Override
        public String getLink() {
            return URLService.locate((OID)this.m_category.getOID());
        }

        @Override
        public String getDescription() {
            return this.m_category.getDescription();
        }
    }

    private class CategoryPurposeItemCollection
    implements RSSItemCollection {
        private Iterator m_categories;
        private Category m_category;

        public CategoryPurposeItemCollection(Collection categories) {
            this.m_categories = categories.iterator();
            this.m_category = null;
        }

        @Override
        public boolean next() {
            if (this.m_categories.hasNext()) {
                this.m_category = (Category)this.m_categories.next();
                return true;
            }
            this.m_category = null;
            return false;
        }

        @Override
        public RSSItem getItem() {
            Assert.exists((Object)this.m_category, Category.class);
            return new CategoryPurposeItem(this.m_category);
        }
    }
}

