/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.rssfeed.portlet;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.rssfeed.RSSChannel;
import com.arsdigita.rssfeed.RSSImage;
import com.arsdigita.rssfeed.RSSItem;
import com.arsdigita.rssfeed.RSSItemCollection;
import com.arsdigita.rssfeed.SimpleRSSItem;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationCollection;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;

public class WorkspaceDirectoryChannel
implements RSSChannel {
    private static final String WORKSPACE_OBJECT_TYPE = "com.arsdigita.london.portal.Workspace";
    private RSSImage m_image;
    private Party m_party;
    private String m_link;

    public WorkspaceDirectoryChannel(Party party, String link, RSSImage image) {
        this.m_image = image;
        this.m_party = party;
        this.m_link = link;
    }

    @Override
    public String getTitle() {
        return "Workspace Directory";
    }

    @Override
    public String getLink() {
        return this.m_link;
    }

    @Override
    public String getDescription() {
        return "Workspace Directory for " + (this.m_party == null ? "The Public" : this.m_party.getDisplayName());
    }

    @Override
    public RSSImage getImage() {
        return this.m_image;
    }

    @Override
    public RSSItemCollection getItems() {
        Application current = Web.getContext().getApplication();
        ApplicationCollection workspaces = Application.retrieveAllApplications();
        workspaces.addEqualsFilter("objectType", (Object)WORKSPACE_OBJECT_TYPE);
        workspaces.addNotEqualsFilter("id", (Object)current.getID());
        workspaces.addOrder("title");
        PermissionService.filterObjects((DomainCollection)workspaces, (PrivilegeDescriptor)PrivilegeDescriptor.READ, this.m_party == null ? null : this.m_party.getOID());
        return new WorkspaceItemCollection(workspaces);
    }

    private class WorkspaceItemCollection
    implements RSSItemCollection {
        private ApplicationCollection m_workspaces;

        public WorkspaceItemCollection(ApplicationCollection workspaces) {
            this.m_workspaces = workspaces;
        }

        @Override
        public boolean next() {
            return this.m_workspaces.next();
        }

        @Override
        public RSSItem getItem() {
            Application app = this.m_workspaces.getApplication();
            return new SimpleRSSItem(app.getTitle(), URL.there((Application)app, (String)"/", null).toString(), app.getDescription());
        }
    }
}

