/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.rssfeed.ui;

import com.arsdigita.categorization.Category;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.rssfeed.RSSService;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ChannelGenerator
implements Dispatcher {
    private static final org.apache.log4j.Category s_log = org.apache.log4j.Category.getInstance(ChannelGenerator.class);

    public void dispatch(HttpServletRequest request, HttpServletResponse response, RequestContext actx) throws IOException, ServletException {
        Category cat = this.retrieveChannelCategory(request);
        if (cat == null) {
            response.setStatus(404);
        } else {
            this.channelPage(cat, request, response, actx);
        }
    }

    private void channelPage(Category cat, HttpServletRequest request, HttpServletResponse response, RequestContext actx) throws IOException {
        response.setStatus(200);
        try {
            RSSService.generateChannel(cat.getID(), request, response);
        }
        catch (Exception e) {
            throw new UncheckedWrapperException((Throwable)e);
        }
    }

    private Category retrieveChannelCategory(HttpServletRequest req) {
        Category cat;
        BigDecimal id;
        String o = req.getParameter("id");
        try {
            id = new BigDecimal(o);
        }
        catch (Exception e) {
            return null;
        }
        try {
            cat = new Category(id);
        }
        catch (Exception e2) {
            return null;
        }
        return cat;
    }
}

