/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.versioning.VersionedACSObject;
import java.math.BigDecimal;

public class Organization
extends ContentPage {
    public static final String LINK = "link";
    public static final String CONTACT = "contact";
    public static final String IMAGE = "image";
    public static final String IMAGE_ID = "imageID";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.Organization";

    public Organization() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public Organization(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Organization(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public Organization(DataObject obj) {
        super(obj);
    }

    public Organization(String type) {
        super(type);
    }

    public void beforeSave() {
        super.beforeSave();
        Assert.exists((Object)this.getContentType(), ContentType.class);
    }

    public String getLink() {
        return (String)this.get(LINK);
    }

    public void setLink(String link) {
        this.set(LINK, link);
    }

    public String getContact() {
        return (String)this.get(CONTACT);
    }

    public void setContact(String contact) {
        this.set(CONTACT, contact);
    }

    public BigDecimal getImageID() {
        return (BigDecimal)this.get(IMAGE_ID);
    }

    public ImageAsset getImage() {
        DataObject obj = (DataObject)this.get(IMAGE);
        if (obj == null) {
            return null;
        }
        return new ImageAsset(obj);
    }

    public void setImage(ImageAsset image) {
        if (image != null) {
            image.setMaster((VersionedACSObject)this);
        }
        this.setAssociation(IMAGE, (DomainObject)image);
    }

    public void delete() {
        ImageAsset image = this.getImage();
        if (image != null) {
            this.setAssociation(IMAGE, null);
            this.save();
            image.delete();
        }
        super.delete();
    }
}

