/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.auth.http.ui;

import com.arsdigita.auth.http.UserLogin;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.PersonName;
import com.arsdigita.kernel.User;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class UserCSVEntry {
    private static final Logger s_log = Logger.getLogger(UserCSVEntry.class);
    public static final String[] s_fields = new String[]{"First Name", "Last name", "E-mail address", "Primary Windows NT Account"};
    private static final int FIRST_NAME = 0;
    private static final int LAST_NAME = 1;
    private static final int EMAIL_ADDRESS = 2;
    private static final int NT_ACCOUNT = 3;
    private static final int EOF = -1;
    private static final int QUOTE = 34;
    private static final int COMMA = 44;
    private static final int CR = 13;
    private static final int LF = 10;
    private ArrayList m_values = new ArrayList(s_fields.length);
    private String m_email = null;
    private static Reader s_csv;
    private static StringBuffer s_buffer;
    private static int s_char;

    private UserCSVEntry() {
    }

    public static void init(Reader r) {
        s_csv = r;
        s_buffer = new StringBuffer();
        UserCSVEntry.nextChar();
    }

    public static void skipEntry() {
        try {
            do {
                s_char = s_csv.read();
                System.err.print(new String(new byte[]{(byte)s_char}));
            } while (s_char != 13 && s_char != 10 && s_char != -1);
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException((Throwable)ex);
        }
    }

    public static synchronized boolean hasMore() {
        return s_csv != null;
    }

    public static synchronized UserCSVEntry nextEntry() {
        Assert.isTrue((boolean)UserCSVEntry.hasMore(), (String)"has more entries");
        UserCSVEntry entry = new UserCSVEntry();
        s_log.debug((Object)"Starting entry");
        block2: do {
            entry.m_values.clear();
            s_buffer.setLength(0);
            boolean inQuotes = false;
            while (true) {
                if (s_char == -1 || s_char == 13 || s_char == 10) {
                    UserCSVEntry.addField(entry.m_values);
                    s_log.debug((Object)("Got one " + entry.m_values));
                    if (s_char == -1) continue block2;
                    do {
                        UserCSVEntry.nextChar();
                    } while (s_char == 10 || s_char == 13);
                    continue block2;
                }
                if (s_char == 34) {
                    inQuotes = !inQuotes;
                } else if (!inQuotes && s_char == 44) {
                    UserCSVEntry.addField(entry.m_values);
                    s_log.debug((Object)("Got one more " + entry.m_values));
                } else {
                    s_buffer.append((char)s_char);
                }
                UserCSVEntry.nextChar();
            }
        } while (s_char != -1 && entry.m_values.size() != s_fields.length);
        if (s_char == -1) {
            try {
                s_csv.close();
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException((Throwable)ex);
            }
            s_csv = null;
            s_buffer = null;
        }
        return entry.m_values.size() == s_fields.length ? entry : null;
    }

    private static void nextChar() {
        try {
            s_char = s_csv.read();
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException((Throwable)ex);
        }
    }

    private static void addField(ArrayList l) {
        l.add(s_buffer.toString().trim());
        s_buffer.setLength(0);
    }

    public String getFirstName() {
        return this.m_values.get(0).toString();
    }

    public String getLastName() {
        return this.m_values.get(1).toString();
    }

    public String getNTAccount() {
        return this.m_values.get(3).toString();
    }

    public String getPrimaryEmail() {
        return this.m_values.get(2).toString();
    }

    public boolean isValid() {
        s_log.debug((Object)("Checking " + this.getFirstName() + ":" + this.getLastName() + ":" + this.getNTAccount() + ":" + this.getPrimaryEmail()));
        String nt = this.getNTAccount();
        nt = nt.toLowerCase();
        if (nt.length() == 0) {
            s_log.debug((Object)"NT account empty");
            return false;
        }
        int sepInd = nt.indexOf("\\");
        if (sepInd == -1) {
            s_log.debug((Object)"NT account missing separator");
            return false;
        }
        String userName = nt.substring(sepInd + 1);
        if (userName.length() == 0) {
            s_log.debug((Object)"NT account missing username");
            return false;
        }
        if (userName.equals("administrator")) {
            s_log.debug((Object)"NT account is administrator");
            return false;
        }
        if (this.getFirstName().length() == 0 || this.getLastName().length() == 0) {
            s_log.debug((Object)"First / last name empty");
            return false;
        }
        return true;
    }

    public void createUser() {
        String firstName = this.getFirstName();
        String lastName = this.getLastName();
        String ident = this.getNTAccount();
        String email = this.getPrimaryEmail();
        User user = new User();
        PersonName name = user.getPersonName();
        name.setGivenName(firstName);
        name.setFamilyName(lastName);
        user.setPrimaryEmail(new EmailAddress(email));
        UserLogin login = UserLogin.create(user, ident);
    }

    private boolean empty(String s) {
        return s == null || s.length() == 0;
    }

    public String toString() {
        return this.getPrimaryEmail() + ":" + this.getNTAccount();
    }
}

