/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.portalserver.ApplicationAuthenticationListener;
import com.arsdigita.portalserver.CWPage;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ApplicationPage
extends CWPage {
    private static Logger log = Logger.getLogger((String)ApplicationPage.class.getName());

    protected ApplicationPage() {
        this(true);
    }

    protected ApplicationPage(boolean checkPermission) {
        if (checkPermission) {
            this.addRequestListener(new ApplicationAuthenticationListener("read"));
        }
    }

    public void lock() {
        this.buildPage();
        super.lock();
    }

    protected final void buildPage() {
        this.buildTitle();
        this.buildContextBar();
        this.buildGlobal(this.getGlobal());
        this.buildHeader(this.getHeader());
        this.buildBody(this.getBody());
        this.buildFooter(this.getFooter());
    }

    protected void buildTitle() {
        this.setTitle(new Label((PrintListener)new CurrentApplicationLabelPrinter()));
    }

    protected void buildContextBar() {
        DimensionalNavbar navbar = new DimensionalNavbar();
        navbar.setClassAttr("portalNavbar");
        navbar.add((Component)new Link((PrintListener)new CurrentApplicationLinkPrinter()));
        this.getHeader().add((Component)navbar);
    }

    protected void buildGlobal(Container global) {
        Link link = new Link((Component)new Label(GlobalizationUtil.globalize("cw.workspace.sign_out")), "/register/logout");
        link.setClassAttr("signoutLink");
        this.getGlobal().add((Component)link);
    }

    protected void buildHeader(Container header) {
    }

    protected void buildBody(Container body) {
    }

    protected void buildFooter(Container footer) {
    }

    protected class ParentApplicationLinkPrinter
    implements PrintListener {
        public void prepare(PrintEvent e) {
            Link link = (Link)e.getTarget();
            PageState pageState = e.getPageState();
            Application app = Application.getCurrentApplication((HttpServletRequest)pageState.getRequest());
            Assert.exists((Object)app, (String)"Application app");
            Application parent = app.getParentApplication();
            link.setChild((Component)new Label(parent.getTitle()));
            link.setTarget(parent.getPrimaryURL());
        }
    }

    protected class CurrentApplicationLabelPrinter
    implements PrintListener {
        public void prepare(PrintEvent e) {
            Label label = (Label)e.getTarget();
            PageState pageState = e.getPageState();
            Application app = Application.getCurrentApplication((HttpServletRequest)pageState.getRequest());
            Assert.exists((Object)app, (String)"Application app");
            label.setLabel(app.getTitle());
        }
    }

    protected class CurrentApplicationLinkPrinter
    implements PrintListener {
        public void prepare(PrintEvent e) {
            Link link = (Link)e.getTarget();
            PageState pageState = e.getPageState();
            Application app = Application.getCurrentApplication((HttpServletRequest)pageState.getRequest());
            Assert.exists((Object)app, (String)"Application app");
            link.setChild((Component)new Label(app.getTitle()));
            link.setTarget(app.getPrimaryURL());
        }
    }

    protected class PersonalPortalLinkPrinter
    implements PrintListener {
        public void prepare(PrintEvent e) {
            Link link = (Link)e.getTarget();
            Party party = Kernel.getContext().getParty();
            Assert.exists((Object)party, (String)"Party party");
            link.setChild((Component)new Label(GlobalizationUtil.globalize("cw.workspace.personal_workspace")));
            link.setTarget("/personal-portal/" + party.getID() + "/");
        }
    }
}

