/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.portalserver.PortalNavigatorPortlet;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.PortalSiteCollection;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.xml.Element;

class PortalNavigatorPortletRenderer
extends AbstractPortletRenderer {
    private PortalNavigatorPortlet m_portlet;

    public PortalNavigatorPortletRenderer(PortalNavigatorPortlet portlet) {
        this.m_portlet = portlet;
    }

    protected void generateBodyXML(PageState pageState, Element parentElement) {
        PortalSite currentPortal = (PortalSite)this.m_portlet.getParentApplication();
        if (currentPortal == null) {
            return;
        }
        GridPanel panel = new GridPanel(2);
        String title = null;
        String url = null;
        PortalSite portalsite = PortalSite.getPortalSiteForApplication(currentPortal);
        if (portalsite != null) {
            title = portalsite.getTitle();
            url = portalsite.getPrimaryURL();
            panel.add((Component)new Link(title, url));
            Label l = new Label(GlobalizationUtil.globalize("cw.workspace.parent"));
            l.setFontWeight("i");
            panel.add((Component)l, 4);
        }
        PortalSiteCollection childPortals = currentPortal.getChildPortalSites();
        int counter = 0;
        while (childPortals.next()) {
            title = childPortals.getTitle();
            url = childPortals.getPrimaryURL();
            panel.add((Component)new Link(title, url));
            Label l = new Label(GlobalizationUtil.globalize("cw.workspace.child"));
            l.setFontWeight("i");
            panel.add((Component)l, 4);
            ++counter;
        }
        PortalSiteCollection relatedPortals = currentPortal.getRelatedPortalSites();
        counter = 0;
        while (relatedPortals.next()) {
            title = relatedPortals.getTitle();
            url = relatedPortals.getPrimaryURL();
            panel.add((Component)new Link(title, url));
            panel.add((Component)new Label(""));
            ++counter;
        }
        panel.generateXML(pageState, parentElement);
    }
}

