/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.personal;

import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Resource;
import com.arsdigita.kernel.ResourceTypeConfig;
import com.arsdigita.kernel.User;
import com.arsdigita.portalserver.personal.PersonalPortal;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.templating.Templating;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import com.arsdigita.web.BaseApplicationServlet;
import com.arsdigita.xml.Document;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class PersonalPortalCreatorServlet
extends BaseApplicationServlet {
    private static final Logger s_log = Logger.getLogger(PersonalPortalCreatorServlet.class);
    private static final String XSL_HOOK = "portal-sitemap";
    private static final PresentationManager s_presManager = Templating.getPresentationManager();
    private static Page s_introPage;

    public void doInit() throws ServletException {
        s_log.debug((Object)"PortalSiteMapServlet doInit() initialization executing!");
        s_introPage = this.buildIntroPage();
    }

    public void doService(HttpServletRequest sreq, HttpServletResponse sresp, Application app) throws ServletException, IOException {
        s_log.debug((Object)("PortalSiteMApServlet.doService called for request '" + sreq.getRequestURI() + "'"));
        RequestContext ctx = DispatcherHelper.getRequestContext();
        final Application parent = app;
        BigDecimal userID = this.scanUserID(sreq);
        if (userID == null) {
            s_log.warn((Object)"Failed to read a user ID from a personal-portal link.");
        } else {
            final User user = this.getUser(userID);
            PersonalPortal portal = PersonalPortal.retrievePersonalPortal(user);
            if (portal == null) {
                KernelExcursion rootExcursion = new KernelExcursion(){

                    protected void excurse() {
                        this.setParty(Kernel.getSystemParty());
                        PersonalPortal ps = PersonalPortal.createPersonalPortal(user, parent);
                        Assert.exists((Object)((Object)ps), (String)"portal");
                        PersonalPortalCreatorServlet.this.configurePortal(ps);
                        ps.save();
                    }
                };
                rootExcursion.run();
            } else {
                s_log.error((Object)"PersonalPortalCreator invoked when the portalsite already exists.", (Throwable)new IllegalStateException());
            }
        }
        Document doc = null;
        doc = s_introPage.buildDocument(sreq, sresp);
        s_presManager.servePage(doc, sreq, sresp);
    }

    private Page buildIntroPage() {
        Page page = new Page("", (Container)new SimpleContainer());
        page.lock();
        return page;
    }

    private Application getApplication(RequestContext ctx) {
        return null;
    }

    private BigDecimal scanUserID(HttpServletRequest sreq) {
        String url = sreq.getPathInfo();
        int delimIndex = url.indexOf("/");
        try {
            if (delimIndex == -1) {
                return new BigDecimal(url);
            }
            return new BigDecimal(url.substring(0, delimIndex));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        catch (IndexOutOfBoundsException iobe) {
            return null;
        }
    }

    private User getUser(BigDecimal userID) {
        User user = null;
        try {
            user = User.retrieve((BigDecimal)userID);
        }
        catch (DataObjectNotFoundException nfe) {
            s_log.error((Object)("Failed to retrieve user " + userID + "."), (Throwable)new IllegalStateException());
        }
        Assert.exists((Object)user, (String)"user");
        return user;
    }

    private void configurePortal(PersonalPortal portal) {
        ResourceTypeConfig config = portal.getApplicationType().getConfig();
        Assert.exists((Object)config, (String)"config");
        config.configureResource((Resource)portal);
    }
}

