/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.CompoundComponent;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.ui.ResourceConfigFormSection;
import com.arsdigita.portal.PortletType;
import com.arsdigita.portal.PortletTypeCollection;
import com.arsdigita.web.ApplicationType;
import com.arsdigita.web.ApplicationTypeCollection;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ApplicationCreateComponent
extends CompoundComponent {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ui/admin/ApplicationCreateComponent.java#5 $$Author: dennis $$DateTime: 2004/08/17 23:19:25 $";
    private static final Logger s_log = Logger.getLogger(ApplicationCreateComponent.class);
    private RequestLocal m_appTypeRL;
    private HashMap m_configureComponents;

    public ApplicationCreateComponent(RequestLocal appTypeRL, RequestLocal parentApplicationRL, boolean forPortlets, ActionListener onSuccess, ActionListener onCancel) {
        this(appTypeRL, parentApplicationRL, forPortlets, new DefaultBuilder(onSuccess, onCancel));
    }

    public ApplicationCreateComponent(RequestLocal appTypeRL, RequestLocal parentApplicationRL, boolean forPortlets, Builder builder) {
        this.m_appTypeRL = appTypeRL;
        this.m_configureComponents = new HashMap();
        if (forPortlets) {
            s_log.debug((Object)"Building a portlet create component");
            PortletTypeCollection types = PortletType.retrieveAllPortletTypes();
            while (types.next()) {
                PortletType type = types.getPortletType();
                ResourceConfigFormSection config = type.getCreateFormSection(parentApplicationRL);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Fetched config " + config + " for type '" + type.getTitle() + "' with ID " + type.getID()));
                }
                if (config == null) continue;
                Component c = builder.build(config);
                this.m_configureComponents.put(type.getID(), c);
                this.add(c);
            }
        } else {
            s_log.debug((Object)"Building an application create component");
            ApplicationTypeCollection types = ApplicationType.retrieveAllApplicationTypes();
            while (types.next()) {
                ApplicationType type = types.getApplicationType();
                ResourceConfigFormSection config = type.getCreateFormSection(parentApplicationRL);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Fetched config " + config + " for type '" + type.getTitle() + "'"));
                }
                if (config == null) continue;
                Component c = builder.build(config);
                this.m_configureComponents.put(type.getID(), c);
                this.add(c);
            }
        }
    }

    public Component get(PageState ps) {
        ResourceType rt = (ResourceType)this.m_appTypeRL.get(ps);
        if (!this.canCreate(rt)) {
            throw new IllegalStateException("can not display form for a: " + rt.getTitle());
        }
        return (Component)this.m_configureComponents.get(rt.getID());
    }

    public void generateXML(PageState ps, Element parentElt) {
        Component c = this.get(ps);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Generating XML of component " + c + " fetched " + "using ID " + ((ResourceType)this.m_appTypeRL.get(ps)).getID()));
        }
        c.generateXML(ps, parentElt);
    }

    public boolean canCreate(BigDecimal appTypeID) {
        return this.m_configureComponents.containsKey(appTypeID);
    }

    public boolean canCreate(ResourceType rt) {
        return this.m_configureComponents.containsKey(rt.getID());
    }

    public static class DefaultBuilder
    implements Builder {
        private final ActionListener m_onSuccess;
        private final ActionListener m_onCancel;

        public DefaultBuilder(ActionListener onSuccess, ActionListener onCancel) {
            this.m_onSuccess = onSuccess;
            this.m_onCancel = onCancel;
        }

        @Override
        public Component build(final ResourceConfigFormSection acfs) {
            final Form f = new Form("ac", (Container)new GridPanel(1));
            f.add((Component)acfs);
            BoxPanel buttons = new BoxPanel(1);
            final Submit create = new Submit("Create");
            final Submit cancel = new Submit("Cancel");
            buttons.add((Component)create);
            buttons.add((Component)cancel);
            f.add((Component)buttons);
            f.addProcessListener(new FormProcessListener(){

                public void process(FormSectionEvent ev) throws FormProcessException {
                    PageState ps = ev.getPageState();
                    if (create.isSelected(ps)) {
                        acfs.createResource(ps).save();
                        DefaultBuilder.this.m_onSuccess.actionPerformed(new ActionEvent((Component)f, ps));
                    } else if (cancel.isSelected(ps)) {
                        DefaultBuilder.this.m_onCancel.actionPerformed(new ActionEvent((Component)f, ps));
                    }
                }
            });
            return f;
        }
    }

    public static interface Builder {
        public Component build(ResourceConfigFormSection var1);
    }
}

