/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.tree.TreeCellRenderer;
import com.arsdigita.bebop.tree.TreeModel;
import com.arsdigita.bebop.tree.TreeModelBuilder;
import com.arsdigita.bebop.tree.TreeNode;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainCollectionIterator;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.PortalSiteCollection;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class PortalTreeModelBuilder
extends LockableImpl
implements TreeModelBuilder {
    private static final Logger s_log = Logger.getLogger(PortalTreeModelBuilder.class);
    private BigDecimal m_rootId;
    private boolean m_filterPSites;

    public PortalTreeModelBuilder() {
        this(null, true);
    }

    public PortalTreeModelBuilder(boolean filterPSites) {
        this(null, filterPSites);
    }

    public PortalTreeModelBuilder(BigDecimal rootprtlId) {
        this.m_rootId = rootprtlId;
        this.m_filterPSites = true;
    }

    public PortalTreeModelBuilder(BigDecimal rootprtlId, boolean filterPSites) {
        this.m_rootId = rootprtlId;
        this.m_filterPSites = filterPSites;
    }

    public BigDecimal getRootID() {
        return this.m_rootId;
    }

    public boolean getFilterPSites() {
        return this.m_filterPSites;
    }

    public void setFilterPSites(boolean filterPSites) {
        this.m_filterPSites = filterPSites;
    }

    public TreeModel makeModel(Tree t, PageState s) {
        return new TreeModel(){

            public Iterator getChildren(TreeNode n, PageState ps) {
                PortalSite psite = (PortalSite)((Object)n.getElement());
                PortalSiteCollection psc = psite == null ? (PortalTreeModelBuilder.this.m_filterPSites ? PortalSite.getRootPortalSites() : PortalSite.getAllRootPortalSites()) : (PortalTreeModelBuilder.this.m_filterPSites ? psite.getChildPortalSites() : psite.getAllChildPortalSites());
                final DomainCollectionIterator dci = new DomainCollectionIterator((DomainCollection)psc);
                return new Iterator(){

                    @Override
                    public boolean hasNext() {
                        return dci.hasNext();
                    }

                    public Object next() {
                        final PortalSite psite = (PortalSite)((Object)dci.next());
                        return new TreeNode(){

                            public Object getElement() {
                                return psite;
                            }

                            public Object getKey() {
                                return psite.getID().toString();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public TreeNode getRoot(PageState ps) {
                if (PortalTreeModelBuilder.this.getRootID() == null) {
                    return new TreeNode(){

                        public Object getElement() {
                            return null;
                        }

                        public Object getKey() {
                            return "root";
                        }
                    };
                }
                final PortalSite psite = PortalSite.retrievePortalSite(PortalTreeModelBuilder.this.getRootID());
                return new TreeNode(){

                    public Object getElement() {
                        return psite;
                    }

                    public Object getKey() {
                        return psite.getID();
                    }
                };
            }

            public boolean hasChildren(TreeNode n, PageState ps) {
                PortalSite psite = (PortalSite)((Object)n.getElement());
                PortalSiteCollection psc = psite == null ? (PortalTreeModelBuilder.this.m_filterPSites ? PortalSite.getRootPortalSites() : PortalSite.getAllRootPortalSites()) : (PortalTreeModelBuilder.this.m_filterPSites ? psite.getChildPortalSites() : psite.getAllChildPortalSites());
                boolean isEmpty = psc.isEmpty();
                psc.close();
                return !isEmpty;
            }
        };
    }

    public static class DefaultRenderer
    implements TreeCellRenderer {
        public Component getComponent(Tree tree, PageState ps, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, Object key) {
            PortalSite psite = (PortalSite)((Object)value);
            if (psite == null) {
                return new Label("");
            }
            String title = psite.getTitle();
            SimpleContainer result = new SimpleContainer();
            Label l = new Label(title);
            if (isSelected) {
                l.setFontWeight("b");
                result.add((Component)l);
            } else {
                result.add((Component)new ControlLink((Component)l));
            }
            String psURL = psite.getSiteNode().getURL();
            result.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.")));
            Link viewLink = new Link((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.view")), psURL);
            viewLink.setTargetFrame("_blank");
            result.add((Component)viewLink);
            result.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.")));
            return result;
        }
    }
}

