/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.atoz;

import com.arsdigita.atoz.AtoZAtomicEntry;
import com.arsdigita.atoz.AtoZEntry;
import com.arsdigita.atoz.AtoZGeneratorAbstractImpl;
import com.arsdigita.atoz.AtoZProvider;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.london.atoz.DomainProvider;
import com.arsdigita.london.terms.Domain;
import com.arsdigita.london.terms.Term;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.util.ArrayList;

public class DomainGenerator
extends AtoZGeneratorAbstractImpl {
    public DomainGenerator(DomainProvider provider) {
        super((AtoZProvider)provider);
    }

    public AtoZEntry[] getEntries(String letter) {
        DomainProvider provider = (DomainProvider)this.getProvider();
        Domain domain = provider.getDomain();
        DomainCollection terms = domain.getTerms();
        terms.addPath("model.id");
        terms.addPath("model.objectType");
        terms.addPath("model.description");
        terms.addEqualsFilter("inAtoZ", (Object)Boolean.TRUE);
        Filter f = terms.addFilter("lower(model.name) like :key");
        f.set("key", (Object)(letter.toLowerCase() + "%"));
        terms.addOrder("model.name");
        ArrayList<DomainAtomicEntry> l = new ArrayList<DomainAtomicEntry>();
        while (terms.next()) {
            Term term = (Term)terms.getDomainObject();
            DataObject cat = (DataObject)terms.get("model");
            l.add(new DomainAtomicEntry(cat.getOID(), (String)cat.get("name"), (String)cat.get("description")));
        }
        return l.toArray(new AtoZEntry[l.size()]);
    }

    private class DomainAtomicEntry
    implements AtoZAtomicEntry {
        private OID m_oid;
        private String m_title;
        private String m_description;

        public DomainAtomicEntry(OID oid, String title, String description) {
            this.m_oid = oid;
            this.m_title = title;
            this.m_description = description;
        }

        public String getTitle() {
            return this.m_title;
        }

        public String getDescription() {
            return this.m_description;
        }

        public String getLink() {
            ParameterMap map = new ParameterMap();
            map.setParameter("oid", this.m_oid.toString());
            URL here = Web.getContext().getRequestURL();
            return new URL(here.getScheme(), here.getServerName(), here.getServerPort(), "", "", "/redirect/", map).toString();
        }

        public Element getContent() {
            return null;
        }
    }
}

