/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumSubscription;
import com.arsdigita.forum.Post;
import com.arsdigita.kernel.Party;
import com.arsdigita.messaging.Message;
import com.arsdigita.notification.Digest;
import com.arsdigita.notification.Notification;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

public class DailySubscription
extends ForumSubscription {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.forum.ForumSubscription";
    private Digest m_digest;
    private static final String DIGEST = "digest";

    public DailySubscription(Forum forum, Party sender) {
        this(BASE_DATA_OBJECT_TYPE, forum, sender);
    }

    public DailySubscription(String typeName, Forum forum, Party sender) {
        super(typeName, forum);
        Assert.exists((Object)sender, Party.class);
        Digest digest = null;
        String subject = "Daily digest from " + forum.getDisplayName() + " forum";
        digest = new Digest(sender, subject, subject, "-- End digest --");
        digest.setFrequency(1440);
        this.setDigest(digest);
        this.setIsModerationAlert(false);
    }

    protected DailySubscription(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    protected DailySubscription(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected DailySubscription(DataObject data) {
        super(data);
    }

    @Override
    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    @Override
    public String getSubscriptionGroupName() {
        return "Daily Digest Subscription Group";
    }

    private Digest getDigest() {
        DataObject digestData;
        if (this.m_digest == null && (digestData = (DataObject)this.get(DIGEST)) != null) {
            this.m_digest = new Digest(digestData);
        }
        return this.m_digest;
    }

    private void setDigest(Digest digest) {
        this.m_digest = digest;
        this.setAssociation(DIGEST, (DomainObject)this.m_digest);
    }

    public void sendNotification(Post post) {
        Notification notification = new Notification((Party)this.getGroup(), (Message)post);
        notification.setDigest(this.getDigest());
        if (Forum.getConfig().deleteNotifications()) {
            notification.setMessageDelete(Boolean.FALSE);
            notification.setIsPermanent(Boolean.FALSE);
        }
        notification.save();
    }

    public static ForumSubscription getFromForum(Forum forum) {
        DataCollection subs = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        subs.addEqualsFilter("forum.id", (Object)forum.getID());
        subs.addNotEqualsFilter("digest.id", null);
        if (subs.next()) {
            DailySubscription sub = new DailySubscription(subs.getDataObject());
            subs.close();
            return sub;
        }
        return null;
    }
}

