/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.categorization.Category;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.forum.DailySubscription;
import com.arsdigita.forum.ForumConfig;
import com.arsdigita.forum.ForumSubscription;
import com.arsdigita.forum.ModerationAlert;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.ThreadCollection;
import com.arsdigita.forum.ThreadSubscription;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class Forum
extends Application {
    private static final Logger s_log = Logger.getLogger(Forum.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.forum.Forum";
    public static final String PACKAGE_TYPE = "forum";
    public static final String THREAD_SUBSCRIPTION_GROUPS_NAME = "Thread Subscription Groups";
    private static final ForumConfig s_config = new ForumConfig();
    public static final String FORUM_MODERATION_PRIVILEGE = "forum_moderation";
    public static final String CREATE_THREAD_PRIVILEGE = "forum_create_thread";
    public static final String RESPOND_TO_THREAD_PRIVILEGE = "forum_respond";
    public static final String FORUM_READ_PRIVILEGE = "forum_read";
    private static final String POSTS = "posts";
    private static final String SUBSCRIPTIONS = "subscriptions";
    private static final String MODERATION = "isModerated";
    private static final String PUBLIC = "isPublic";
    private static final String NOTICEBOARD = "isNoticeboard";
    private static final String ADMIN_GROUP = "adminGroup";
    private static final String MODERATION_GROUP = "moderationGroup";
    private static final String THREAD_CREATE_GROUP = "threadCreateGroup";
    private static final String THREAD_RESPONDER_GROUP = "threadRespondGroup";
    private static final String READ_GROUP = "readGroup";
    private static final String CATEGORY = "category";
    private static final String EXPIRE_AFTER = "expireAfter";
    private static final String LIFECYCLE_DEFINITION = "lifecycleDefinition";
    private static final String ALLOW_FILE_ATTACHMENTS = "fileAttachmentsAllowed";
    private static final String ALLOW_IMAGE_UPLOADS = "imageUploadsAllowed";
    private static final String AUTOSUBSCRIBE_THREAD_STARTER = "autoSubscribeThreadStarter";
    private static final String INTRODUCTION = "introduction";
    private static final String NO_CATEGORY_POSTS = "noCategoryPostsAllowed";
    private static final String ANONYMOUS_POSTS = "anonymousPostsAllowed";
    private boolean m_wasNew;

    public static ForumConfig getConfig() {
        return s_config;
    }

    public Forum(DataObject data) {
        super(data);
    }

    public Forum(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Forum(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public static Forum create(String urlName, String title, Application parent) {
        return Forum.create(urlName, title, parent, false);
    }

    public static Forum create(String urlName, String title, Application parent, boolean moderated) {
        s_log.debug((Object)("creating forum " + title));
        Forum forum = (Forum)Application.createApplication((String)BASE_DATA_OBJECT_TYPE, (String)urlName, (String)title, (Application)parent, (boolean)true);
        forum.setModerated(moderated);
        forum.setPublic(true);
        forum.setAllowFileAttachments(false);
        forum.setAllowImageUploads(false);
        forum.setAutoSubscribeThreadCreator(false);
        forum.setNoCategoryPostsAllowed(true);
        forum.setAnonymousPostsAllowed(false);
        return forum;
    }

    private void setRootCategory(Category category) {
        Assert.exists((Object)category, Category.class);
        this.setAssociation(CATEGORY, (DomainObject)category);
    }

    public Category getRootCategory() {
        DataObject category = (DataObject)this.get(CATEGORY);
        if (category == null) {
            return this.createRootCategory();
        }
        return (Category)DomainObjectFactory.newInstance((DataObject)category);
    }

    public void setIntroduction(String introduction) {
        this.set(INTRODUCTION, introduction);
    }

    public String getIntroduction() {
        return (String)this.get(INTRODUCTION);
    }

    private Category createRootCategory() {
        Category category = new Category(this.getTitle(), "Root category for forum " + this.getTitle());
        category.save();
        this.setRootCategory(category);
        return category;
    }

    private void createGroups() {
        Group administrators = new Group();
        administrators.setName(this.getTitle() + " Administrators");
        this.setAssociation(ADMIN_GROUP, (DomainObject)administrators);
        Group moderators = new Group();
        moderators.setName(this.getTitle() + " Moderators");
        this.setAssociation(MODERATION_GROUP, (DomainObject)moderators);
        String email = "forum-moderator-" + this.getID() + "-" + moderators.getID() + "@" + s_config.getReplyHostName();
        moderators.setPrimaryEmail(new EmailAddress(email));
        Group threadCreators = new Group();
        threadCreators.setName(this.getTitle() + " Thread Creators");
        this.setAssociation(THREAD_CREATE_GROUP, (DomainObject)threadCreators);
        Group threadResponders = new Group();
        threadResponders.setName(this.getTitle() + " Thread Responders");
        this.setAssociation(THREAD_RESPONDER_GROUP, (DomainObject)threadResponders);
        Group forumReaders = new Group();
        forumReaders.setName(this.getTitle() + " Readers");
        this.setAssociation(READ_GROUP, (DomainObject)forumReaders);
        Group container = this.getGroup();
        container.addSubgroup(administrators);
        container.addSubgroup(moderators);
        container.addSubgroup(threadCreators);
        container.addSubgroup(threadResponders);
        container.addSubgroup(forumReaders);
        Group threadSubscriptions = new Group();
        threadSubscriptions.setName(THREAD_SUBSCRIPTION_GROUPS_NAME);
        container.addSubgroup(threadSubscriptions);
        container.save();
    }

    public void initialize() {
        super.initialize();
        if (this.isNew()) {
            this.setModerated(false);
            this.setNoticeboard(false);
            this.setPublic(true);
            this.setAllowFileAttachments(false);
            this.setAllowImageUploads(false);
            this.setAutoSubscribeThreadCreator(false);
            this.setNoCategoryPostsAllowed(true);
            this.setAnonymousPostsAllowed(false);
            this.createRootCategory();
        }
    }

    protected void beforeSave() {
        this.m_wasNew = this.isNew();
        super.beforeSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterSave() {
        if (this.m_wasNew) {
            PermissionService.setContext((ACSObject)this.getRootCategory(), (ACSObject)this);
            this.createGroups();
            if (this.getAdminGroup() != null) {
                PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)this, (Party)this.getAdminGroup()));
            }
            if (this.getModerationGroup() != null) {
                PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.get((String)FORUM_MODERATION_PRIVILEGE), (ACSObject)this, (Party)this.getModerationGroup()));
            }
            if (this.getThreadCreateGroup() != null) {
                PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.get((String)CREATE_THREAD_PRIVILEGE), (ACSObject)this, (Party)this.getThreadCreateGroup()));
                this.getThreadCreateGroup().addMember(Kernel.getPublicUser());
            }
            if (this.getThreadResponderGroup() != null) {
                PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.get((String)RESPOND_TO_THREAD_PRIVILEGE), (ACSObject)this, (Party)this.getThreadResponderGroup()));
            }
            if (this.getReadGroup() != null) {
                PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.READ, (ACSObject)this, (Party)this.getReadGroup()));
                PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.get((String)FORUM_READ_PRIVILEGE), (ACSObject)this, (Party)this.getReadGroup()));
            }
            KernelExcursion excursion = new KernelExcursion(){

                protected void excurse() {
                    this.setParty(Kernel.getSystemParty());
                }
            };
            excursion.run();
        }
        DataCollection subs = null;
        try {
            subs = this.getSubscriptions();
            if (subs.isEmpty()) {
                this.createSubscriptions();
            }
        }
        finally {
            if (null != subs) {
                subs.close();
            }
        }
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public DataCollection getAllSubscriptions() {
        DataAssociationCursor dac = ((DataAssociation)this.get(SUBSCRIPTIONS)).cursor();
        return dac;
    }

    public DataCollection getSubscriptions() {
        DataCollection subs = this.getAllSubscriptions();
        subs.addEqualsFilter("isModerationAlert", (Object)Boolean.FALSE);
        return subs;
    }

    public DataCollection getModerationAlerts() {
        DataCollection subs = this.getAllSubscriptions();
        subs.addEqualsFilter("isModerationAlert", (Object)Boolean.TRUE);
        return subs;
    }

    public DataAssociation getPosts() {
        return (DataAssociation)this.get(POSTS);
    }

    public DataAssociation getPendingPosts() {
        DataAssociation posts = (DataAssociation)this.get(POSTS);
        FilterFactory factory = posts.getFilterFactory();
        Filter pending = factory.equals("status", (Object)"pending");
        Filter reapprove = factory.equals("status", (Object)"reapprove");
        posts.addFilter((Filter)factory.or().addFilter(pending).addFilter(reapprove));
        return posts;
    }

    public DataAssociation getSuppressedPosts() {
        DataAssociation posts = (DataAssociation)this.get(POSTS);
        posts.addEqualsFilter("status", (Object)"suppressed");
        return posts;
    }

    public ThreadCollection getThreads() {
        return this.getThreads((BigDecimal)null);
    }

    public ThreadCollection getThreads(Party party) {
        ThreadCollection threads = this.getThreads();
        if (this.isModerated() && !this.canModerate(party)) {
            s_log.debug((Object)"Only showing approved threads");
            threads.filterUnapproved(party);
        }
        return threads;
    }

    public ThreadCollection getThreads(BigDecimal categoryID) {
        DataCollection threadsData = SessionManager.getSession().retrieve("com.arsdigita.messaging.Thread");
        threadsData.addEqualsFilter("root.objectID", (Object)this.getID());
        if (categoryID != null) {
            if (categoryID.equals(Constants.TOPIC_NONE)) {
                Filter f = threadsData.addNotInSubqueryFilter("root.id", "com.arsdigita.forum.uncategoryObject");
            } else {
                Filter f = threadsData.addInSubqueryFilter("root.id", "com.arsdigita.forum.categoryObject");
                f.set("categoryID", (Object)categoryID);
            }
        }
        threadsData.addOrder(Forum.getConfig().getThreadOrder());
        return new ThreadCollection(threadsData);
    }

    public ThreadCollection getThreads(BigDecimal categoryID, Party party) {
        ThreadCollection threads = this.getThreads(categoryID);
        if (this.isModerated() && !this.canModerate(party)) {
            s_log.debug((Object)"Only showing approved threads");
            threads.filterUnapproved(party);
        }
        return threads;
    }

    protected void createSubscriptions() {
        s_log.debug((Object)"Creating subscriptions!");
        new KernelExcursion(){

            protected void excurse() {
                this.setParty(Kernel.getSystemParty());
                User party = Forum.getConfig().getDigestUser();
                Assert.exists((Object)party, Party.class);
                new ForumSubscription(Forum.this).save();
                new DailySubscription(Forum.this, (Party)party).save();
                Group moderators = Forum.this.getModerationGroup();
                if (null != moderators) {
                    s_log.debug((Object)("creatiing moderation subscription " + moderators.getName()));
                    new ModerationAlert(Forum.this, moderators).save();
                }
            }
        }.run();
    }

    public DataQuery getCategories() {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.forum.getCategorizationSummary");
        query.setParameter("forumID", (Object)this.getID());
        return query;
    }

    public DataQuery getEmptyCategories() {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.forum.getUnusedCategories");
        query.setParameter("forumID", (Object)this.getID());
        return query;
    }

    public DataQuery getUnCategory() {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.forum.getUncategorizedSummary");
        query.setParameter("forumID", (Object)this.getID());
        return query;
    }

    public DataAssociationCursor getFilledCategories() {
        Category root = this.getRootCategory();
        DataAssociationCursor cursor = root.getRelatedCategories("child");
        Filter f = cursor.addInSubqueryFilter("id", "com.arsdigita.forum.filledCategories");
        return cursor;
    }

    public boolean hasCategorizedPosts(Category cat) {
        ThreadCollection children = this.getThreads(cat.getID());
        return children.size() != 0L;
    }

    public boolean canEdit(Party party) {
        return Forum.getConfig().canAdminEditPosts() && PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.EDIT, (ACSObject)this, party));
    }

    public boolean canDelete(Party party) {
        return (Forum.getConfig().canAdminEditPosts() || Forum.getConfig().canAuthorDeletePosts()) && PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.DELETE, (ACSObject)this, party));
    }

    public boolean canAdminister(Party party) {
        return PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)this, party));
    }

    public boolean canModerate(Party party) {
        return PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.get((String)FORUM_MODERATION_PRIVILEGE), (ACSObject)this, party));
    }

    public void setModerated(boolean moderate) {
        Boolean old = (Boolean)this.get(MODERATION);
        if (Boolean.TRUE.equals(old) && !moderate) {
            DataAssociationCursor posts = this.getPosts().cursor();
            posts.addEqualsFilter("status", (Object)"pending");
            while (posts.next()) {
                Post post = (Post)DomainObjectFactory.newInstance((DataObject)posts.getDataObject());
                post.setStatus("approved");
                post.save();
            }
        }
        this.set(MODERATION, new Boolean(moderate));
    }

    public boolean isModerated() {
        Boolean isModerated = (Boolean)this.get(MODERATION);
        Assert.exists((Object)isModerated);
        return isModerated;
    }

    public boolean isPublic() {
        Boolean isPublic = (Boolean)this.get(PUBLIC);
        Assert.exists((Object)isPublic);
        return isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.set(PUBLIC, new Boolean(isPublic));
    }

    public void setNoticeboard(boolean noticeboard) {
        this.set(NOTICEBOARD, new Boolean(noticeboard));
    }

    public boolean isNoticeboard() {
        return Boolean.TRUE.equals(this.get(NOTICEBOARD));
    }

    public Group getAdminGroup() {
        DataObject dObj = (DataObject)this.get(ADMIN_GROUP);
        Assert.exists((Object)dObj, DataObject.class);
        return (Group)DomainObjectFactory.newInstance((DataObject)dObj);
    }

    public Group getModerationGroup() {
        DataObject dObj = (DataObject)this.get(MODERATION_GROUP);
        Assert.exists((Object)dObj, DataObject.class);
        return (Group)DomainObjectFactory.newInstance((DataObject)dObj);
    }

    public Group getThreadCreateGroup() {
        DataObject dObj = (DataObject)this.get(THREAD_CREATE_GROUP);
        Assert.exists((Object)dObj, DataObject.class);
        return (Group)DomainObjectFactory.newInstance((DataObject)dObj);
    }

    public Group getThreadResponderGroup() {
        DataObject dObj = (DataObject)this.get(THREAD_RESPONDER_GROUP);
        Assert.exists((Object)dObj, DataObject.class);
        return (Group)DomainObjectFactory.newInstance((DataObject)dObj);
    }

    public Group getReadGroup() {
        DataObject dObj = (DataObject)this.get(READ_GROUP);
        Assert.exists((Object)dObj, DataObject.class);
        return (Group)DomainObjectFactory.newInstance((DataObject)dObj);
    }

    public void setExpireAfter(int value) {
        this.set(EXPIRE_AFTER, new BigDecimal(value));
        LifecycleDefinition previousLife = this.getLifecycleDefinition();
        if (previousLife != null) {
            this.setLifecycleDefinition(null);
            previousLife.delete();
        }
        if (value == 0) {
            return;
        }
        LifecycleDefinition newLife = new LifecycleDefinition();
        newLife.setLabel("Delete expired noticeboard postings");
        newLife.addPhaseDefinition("Forum posting lifespan", null, new Integer(0), new Integer(1440 * value), null);
        this.setLifecycleDefinition(newLife);
        DataAssociationCursor posts = this.getPosts().cursor();
        while (posts.next()) {
            Post post = (Post)DomainObjectFactory.newInstance((DataObject)posts.getDataObject());
            if (!post.getThread().getRootMessage().getID().equals(post.getID())) continue;
            s_log.debug((Object)("Resetting expiration lifecycle for " + post.getOID()));
            post.setLifecycle(newLife);
        }
    }

    public int getExpireAfter() {
        BigDecimal expire = (BigDecimal)this.get(EXPIRE_AFTER);
        if (expire == null) {
            return 0;
        }
        return expire.intValue();
    }

    public LifecycleDefinition getLifecycleDefinition() {
        DataObject life = (DataObject)this.get(LIFECYCLE_DEFINITION);
        if (life == null) {
            return null;
        }
        return new LifecycleDefinition(life);
    }

    private void setLifecycleDefinition(LifecycleDefinition life) {
        this.set(LIFECYCLE_DEFINITION, life);
    }

    public void setAdminGroup(Group group) {
        this.setAssociation(ADMIN_GROUP, (DomainObject)group);
        PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)this, (Party)group));
    }

    public void setThreadCreatorGroup(Group group) {
        this.setAssociation(THREAD_CREATE_GROUP, (DomainObject)group);
        PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.get((String)CREATE_THREAD_PRIVILEGE), (ACSObject)this, (Party)group));
    }

    public void setThreadResponderGroup(Group group) {
        this.setAssociation(THREAD_RESPONDER_GROUP, (DomainObject)group);
        PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.get((String)RESPOND_TO_THREAD_PRIVILEGE), (ACSObject)this, (Party)group));
    }

    public void setReaderGroup(Group group) {
        this.setAssociation(READ_GROUP, (DomainObject)group);
        PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.READ, (ACSObject)this, (Party)group));
    }

    public boolean allowFileAttachments() {
        return (Boolean)this.get(ALLOW_FILE_ATTACHMENTS);
    }

    public boolean allowImageUploads() {
        return (Boolean)this.get(ALLOW_IMAGE_UPLOADS);
    }

    public boolean autoSubscribeThreadStarter() {
        return (Boolean)this.get(AUTOSUBSCRIBE_THREAD_STARTER);
    }

    public boolean noCategoryPostsAllowed() {
        return (Boolean)this.get(NO_CATEGORY_POSTS);
    }

    public boolean anonymousPostsAllowed() {
        return (Boolean)this.get(ANONYMOUS_POSTS);
    }

    public void setAllowFileAttachments(boolean allow) {
        this.set(ALLOW_FILE_ATTACHMENTS, new Boolean(allow));
    }

    public void setAllowImageUploads(boolean allow) {
        this.set(ALLOW_IMAGE_UPLOADS, new Boolean(allow));
    }

    public void setAutoSubscribeThreadCreator(boolean subscribe) {
        this.set(AUTOSUBSCRIBE_THREAD_STARTER, new Boolean(subscribe));
    }

    public void setNoCategoryPostsAllowed(boolean allow) {
        this.set(NO_CATEGORY_POSTS, new Boolean(allow));
    }

    public void setAnonymousPostsAllowed(boolean allow) {
        this.set(ANONYMOUS_POSTS, new Boolean(allow));
    }

    public void setTitle(String title) {
        String oldTitle = this.getTitle();
        super.setTitle(title);
        if (!oldTitle.equals(title)) {
            this.getAdminGroup().setName(title + " Administrators");
            this.getModerationGroup().setName(title + " Moderators");
            this.getThreadCreateGroup().setName(title + " Thread Creators");
            this.getThreadResponderGroup().setName(title + " Thread Responders");
            this.getReadGroup().setName(title + " Readers");
            DataCollection subscriptions = this.getSubscriptions();
            while (subscriptions.next()) {
                ForumSubscription subscription = (ForumSubscription)DomainObjectFactory.newInstance((DataObject)subscriptions.getDataObject());
                subscription.getGroup().setName(subscription.getGroupName(this));
            }
            ThreadCollection threads = this.getThreads();
            while (threads.next()) {
                ThreadSubscription threadSub = ThreadSubscription.getThreadSubscription(threads.getMessageThread());
                threadSub.getGroup().setName(threadSub.getSubscriptionGroupName(this));
            }
        }
    }

    public String getServletPath() {
        return "/forum-main/main";
    }

    static {
        s_log.debug((Object)"Static initalizer starting...");
        s_config.load();
        s_log.debug((Object)"Static initalizer finished.");
    }
}

