/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.Post;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.messaging.MessageThread;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public final class ForumContext {
    private static final Logger s_log = Logger.getLogger(ForumContext.class);
    private static final RequestLocal s_context = new RequestLocal(){

        public Object initialValue(PageState state) {
            return new ForumContext();
        }
    };
    private BigDecimal m_threadID;
    private BigDecimal m_categorySelection;
    private MessageThread m_thread;
    private Forum m_forum = (Forum)Kernel.getContext().getResource();
    private boolean m_canEdit;
    private boolean m_canAdminister;
    private boolean m_canModerate;

    ForumContext() {
        Assert.exists((Object)((Object)this.m_forum), Forum.class);
        Party party = Kernel.getContext().getParty();
        this.m_canEdit = this.m_forum.canEdit(party);
        this.m_canModerate = this.m_forum.canModerate(party);
        this.m_canAdminister = this.m_forum.canAdminister(party);
    }

    public static ForumContext getContext(PageState state) {
        return (ForumContext)s_context.get(state);
    }

    static void setContext(PageState state, ForumContext context) {
        s_context.set(state, (Object)context);
    }

    public BigDecimal getThreadID() {
        return this.m_threadID;
    }

    public void setThreadID(BigDecimal threadID) {
        if (this.m_threadID == threadID) {
            return;
        }
        this.m_threadID = threadID;
        try {
            MessageThread thread;
            this.m_thread = thread = new MessageThread(threadID);
        }
        catch (DataObjectNotFoundException ex) {
            PageState state = PageState.getPageState();
            if (state != null) {
                try {
                    state.getResponse().sendError(404);
                    return;
                }
                catch (IOException e) {
                    s_log.warn((Object)"Thread not found, but failed to send a response to user");
                }
            }
            throw new UncheckedWrapperException("Couldn't find a MessageThread for " + threadID, (Throwable)ex);
        }
    }

    public MessageThread getMessageThread() {
        return this.m_thread;
    }

    public Forum getForum() {
        return this.m_forum;
    }

    public boolean canEdit() {
        return this.m_canEdit;
    }

    public boolean canAdminister() {
        return this.m_canAdminister;
    }

    public boolean canDelete(Post post) {
        Party party = Kernel.getContext().getParty();
        return post.canDelete(party);
    }

    public boolean canModerate() {
        return this.m_canModerate;
    }

    public BigDecimal getCategorySelection() {
        return this.m_categorySelection;
    }

    public void setCategorySelection(BigDecimal categorySelection) {
        this.m_categorySelection = categorySelection;
    }
}

