/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageFactory;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.PageBuilder;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.ForumUserCompactView;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.toolbox.ui.ApplicationAuthenticationListener;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;

public class ForumPageBuilder
implements PageBuilder,
Constants {
    @Override
    public Page buildPage() {
        Page page = PageFactory.buildPage((String)"forum", (String)"Forum", (String)"forumPage");
        page.add((Component)new SimpleComponent(){

            public void generateXML(PageState state, Element parent) {
                Element nameElement = parent.newChildElement("forum:name", "http://www.arsdigita.com/forum/1.0");
                nameElement.setText(ForumContext.getContext(state).getForum().getTitle());
                Element introductionElement = parent.newChildElement("forum:introduction", "http://www.arsdigita.com/forum/1.0");
                introductionElement.setText(ForumContext.getContext(state).getForum().getIntroduction());
            }
        });
        ForumUserCompactView forumComp = this.getForumComponent();
        page.add((Component)forumComp);
        BigDecimalParameter topic = new BigDecimalParameter("topic");
        page.addGlobalStateParam((ParameterModel)topic);
        page.addRequestListener((RequestListener)new ApplicationAuthenticationListener(PrivilegeDescriptor.READ));
        page.addRequestListener((RequestListener)new ForumPageRequestListener(topic, forumComp));
        return page;
    }

    protected ForumUserCompactView getForumComponent() {
        return new ForumUserCompactView();
    }

    private static class ForumPageRequestListener
    implements RequestListener {
        private BigDecimalParameter m_categorySelection;
        private ForumUserCompactView m_forumComp;

        public ForumPageRequestListener(BigDecimalParameter topicSelection, ForumUserCompactView forumComp) {
            this.m_categorySelection = topicSelection;
            this.m_forumComp = forumComp;
        }

        public void pageRequested(RequestEvent event) {
            PageState state = event.getPageState();
            ForumContext context = ForumContext.getContext(state);
            context.setCategorySelection((BigDecimal)event.getPageState().getValue((ParameterModel)this.m_categorySelection));
        }
    }
}

