/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumSubscription;
import com.arsdigita.forum.Post;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.messaging.ThreadedMessage;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

public class ModerationAlert
extends ForumSubscription {
    private static final Logger s_log = Logger.getLogger(ModerationAlert.class);
    public static final String MODERATION_ALERTS_QUERY = "com.arsdigita.forum.ModerationAlert";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.forum.ForumSubscription";

    protected void setupSubscriptionGroup() {
    }

    protected void setupSubscriptionGroup(Group moderationGroup) {
        this.setGroup(moderationGroup);
        PrivilegeDescriptor priv = PrivilegeDescriptor.get((String)"forum_moderation");
        PermissionDescriptor permission = new PermissionDescriptor(priv, (ACSObject)this, (Party)moderationGroup);
    }

    protected ModerationAlert(DataObject data) {
        super(data);
    }

    public ModerationAlert(Forum forum, Group moderationGroup) {
        super(BASE_DATA_OBJECT_TYPE, forum);
        this.setIsModerationAlert(true);
        Assert.exists((Object)moderationGroup, Group.class);
        this.setupSubscriptionGroup(moderationGroup);
    }

    @Override
    public String getHeader(ThreadedMessage msg) {
        StringBuffer sb = new StringBuffer();
        sb.append("Forum Moderation Alert\n");
        sb.append(super.getHeader(msg));
        return sb.toString();
    }

    @Override
    public String getSignature(ThreadedMessage msg) {
        StringBuffer sb = new StringBuffer();
        sb.append(SEPARATOR);
        sb.append("This is an automated alert from the Discussion Forum system. ");
        sb.append("You are receiving this email because you are a moderator ");
        sb.append("for this forum, please click on the url below to ");
        sb.append("reject/approve the message. ");
        sb.append(ModerationAlert.getReturnURLMessage((Post)msg));
        return sb.toString();
    }
}

