/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.search;

import com.arsdigita.cms.search.AssetMetadataProvider;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.PostFileAttachment;
import com.arsdigita.kernel.URLService;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class FileAttachmentMetadataProvider
extends AssetMetadataProvider {
    private static Logger s_log = Logger.getLogger(FileAttachmentMetadataProvider.class);

    public String getSummary(DomainObject dobj) {
        PostFileAttachment file = (PostFileAttachment)dobj;
        s_log.debug((Object)("Getting Summary File " + file.getID()));
        Post owner = file.getOwner();
        if (owner == null) {
            return "File attached to forum post";
        }
        String url = URLService.locate((OID)owner.getOID());
        String fileDescription = file.getDescription();
        StringBuffer summary = new StringBuffer();
        if (fileDescription != null) {
            summary.append(fileDescription + " - ");
        }
        summary.append("A file attached to <a href=\"" + url + "\">" + owner.getSubject() + "</a> - a posting by " + ((User)owner.getFrom()).getName() + " to forum " + owner.getForum().getTitle());
        return summary.toString();
    }

    public boolean isIndexable(DomainObject dobj) {
        PostFileAttachment file = (PostFileAttachment)dobj;
        Post owner = file.getOwner();
        Post root = null;
        s_log.debug((Object)"start:isIndexable");
        boolean indexable = false;
        if (owner != null) {
            s_log.debug((Object)("owner = " + (Object)((Object)owner)));
            BigDecimal rootId = owner.getRoot();
            if (rootId != null) {
                root = new Post(owner.getRoot());
            }
            indexable = owner.getStatus().equals("approved") && (root == null || root.getStatus().equals("approved"));
        }
        return indexable;
    }
}

