/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.search;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.search.TextContentProvider;
import com.arsdigita.forum.search.XMLContentProvider;
import com.arsdigita.globalization.SystemLocaleProvider;
import com.arsdigita.kernel.Party;
import com.arsdigita.search.ContentProvider;
import com.arsdigita.search.ContentType;
import com.arsdigita.search.MetadataProvider;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PostMetadataProvider
implements MetadataProvider {
    private static Logger s_log = Logger.getLogger(PostMetadataProvider.class);

    public String getTypeSpecificInfo(DomainObject dobj) {
        return null;
    }

    public Locale getLocale(DomainObject dobj) {
        return new SystemLocaleProvider().getLocale();
    }

    public String getTitle(DomainObject dobj) {
        Post post = (Post)dobj;
        return post.getSubject();
    }

    public String getSummary(DomainObject dobj) {
        Post post = (Post)dobj;
        return "Posted to " + post.getForum().getTitle() + " by " + post.getFrom().getName() + " on " + DateFormat.getDateInstance(2).format(post.getSentDate());
    }

    public Date getCreationDate(DomainObject dobj) {
        Post post = (Post)dobj;
        return post.getSentDate();
    }

    public Party getCreationParty(DomainObject dobj) {
        Post post = (Post)dobj;
        return post.getFrom();
    }

    public Date getLastModifiedDate(DomainObject dobj) {
        return null;
    }

    public Party getLastModifiedParty(DomainObject dobj) {
        return null;
    }

    public ContentProvider[] getContent(DomainObject dobj, ContentType type) {
        ArrayList<Object> content = new ArrayList<Object>();
        if (type.equals(ContentType.XML)) {
            content.add(new XMLContentProvider("xml", (Post)dobj));
        } else if (type.equals(ContentType.TEXT)) {
            content.add(new TextContentProvider("text", (Post)dobj));
        }
        return content.toArray(new ContentProvider[content.size()]);
    }

    public String getContentSection(DomainObject dobj) {
        return null;
    }

    public boolean isIndexable(DomainObject dobj) {
        Post post = (Post)dobj;
        s_log.debug((Object)("Post saved - status is " + post.getStatus() + ". Index Object? " + post.getStatus().equals("approved")));
        return post.getStatus().equals("approved");
    }
}

