/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.BinaryAsset;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.forum.PostImageAttachment;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.ImagesStep;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class ImagesTable
extends SimpleComponent
implements Constants {
    private static Logger s_log = Logger.getLogger(ImagesTable.class);
    protected static final String ACTION_DELETE = "delete";
    private ArrayParameter m_newImages;
    private ArrayParameter m_existingImages;
    private ImagesStep m_parent;

    public ImagesTable(ArrayParameter newImages, ArrayParameter existingImages, ImagesStep parent) {
        this.m_newImages = newImages;
        this.m_existingImages = existingImages;
        this.m_parent = parent;
    }

    public void respond(PageState state) throws ServletException {
        super.respond(state);
        String key = state.getControlEventName();
        String value = state.getControlEventValue();
        if (ACTION_DELETE.equals(key)) {
            List<String> existing = Collections.EMPTY_LIST;
            String[] existingArray = (String[])state.getValue((ParameterModel)this.m_existingImages);
            if (existingArray != null) {
                existing = Arrays.asList(existingArray);
            }
            if (!existing.contains(value)) {
                OID oid = new OID("com.arsdigita.forum.PostImageAttachment", (Object)new BigDecimal(value));
                DomainObjectFactory.newInstance((OID)oid).delete();
            }
            ArrayList<String> newImages = new ArrayList<String>(Arrays.asList((String[])state.getValue((ParameterModel)this.m_newImages)));
            newImages.remove(value);
            String[] current = new String[newImages.size()];
            Iterator it = newImages.iterator();
            int i = 0;
            while (it.hasNext()) {
                current[i++] = (String)it.next();
            }
            state.setValue((ParameterModel)this.m_newImages, (Object)current);
        }
    }

    public void generateXML(PageState state, Element p) {
        Element mainElement = p.newChildElement("forum:attachedImages", "http://www.arsdigita.com/forum/1.0");
        DataCollection images = this.m_parent.getCurrentImages(state);
        if (images == null) {
            return;
        }
        while (images.next()) {
            PostImageAttachment image = (PostImageAttachment)DomainObjectFactory.newInstance((DataObject)images.getDataObject());
            Element imageElement = mainElement.newChildElement("forum:image", "http://www.arsdigita.com/forum/1.0");
            imageElement.addAttribute("name", image.getName());
            imageElement.addAttribute("src", Utilities.getAssetURL((BinaryAsset)image));
            imageElement.addAttribute("caption", image.getDescription());
            this.generateActionXML(state, imageElement, image);
        }
    }

    private void generateActionXML(PageState state, Element parent, PostImageAttachment image) {
        parent.addAttribute("deleteLink", this.makeURL(state, ACTION_DELETE, image));
    }

    protected String makeURL(PageState state, String action, PostImageAttachment image) {
        state.setControlEvent((Component)this, action, image.getID().toString());
        String url = null;
        try {
            url = state.stateAsURL();
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException("cannot create url", (Throwable)ex);
        }
        state.clearControlEvent();
        return url;
    }
}

