/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.DiscussionPostsList;
import com.arsdigita.forum.ui.ReplyToPostForm;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

class MessageView
extends SimpleComponent
implements Constants {
    private static final Logger s_log = Logger.getLogger(MessageView.class);
    private ReplyToPostForm m_container;
    private ACSObjectSelectionModel m_postModel;
    private Post m_post;

    public MessageView(ACSObjectSelectionModel postModel, ReplyToPostForm container) {
        this.m_postModel = postModel;
        this.m_container = container;
    }

    public MessageView(Post post) {
        this.m_post = post;
    }

    public void register(Page page) {
        super.register(page);
        if (this.m_postModel != null) {
            page.addComponentStateParam((Component)this, this.m_postModel.getStateParameter());
        }
    }

    public void generateXML(PageState state, Element parent) {
        Post post = this.m_post;
        if (this.m_post == null) {
            post = (Post)this.m_postModel.getSelectedObject(state);
        }
        if (this.m_container.getContext(state).equals("edit")) {
            post = post.getParent();
        }
        Element messageEl = parent.newChildElement("forum:message", "http://www.arsdigita.com/forum/1.0");
        this.exportAttributes(messageEl);
        DomainObjectXMLRenderer xr = new DomainObjectXMLRenderer(messageEl);
        xr.setWrapRoot(false);
        xr.setWrapAttributes(true);
        xr.setWrapObjects(false);
        xr.walk((DomainObject)post, DiscussionPostsList.class.getName());
    }
}

