/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.ui.CategoryWidget;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.PostForm;
import com.arsdigita.forum.ui.PostTextStep;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class RootPostTextStep
extends PostTextStep {
    private static Logger s_log = Logger.getLogger(RootPostTextStep.class);
    private CategoryWidget m_category = new CategoryWidget((ParameterModel)new BigDecimalParameter("postTopic"));

    public RootPostTextStep(ACSObjectSelectionModel post, PostForm container) {
        super(post, container);
        this.add((Component)this.m_category);
    }

    @Override
    public void setText(Post post, PageState state) {
        super.setText(post, state);
        post.clearCategories();
        post.save();
        BigDecimal categoryID = (BigDecimal)this.m_category.getValue(state);
        if (categoryID != null && !categoryID.equals(Constants.TOPIC_NONE)) {
            post.mapCategory(new Category(categoryID));
        }
    }

    @Override
    protected void initWidgets(PageState state, Post post) {
        super.initWidgets(state, post);
        if (post != null) {
            CategoryCollection categories = post.getCategories();
            if (categories.next()) {
                Category cat = categories.getCategory();
                this.m_category.setValue(state, cat.getID());
            } else {
                this.m_category.setValue(state, Constants.TOPIC_NONE);
            }
            categories.close();
        } else {
            this.m_category.setValue(state, null);
        }
    }
}

