/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.PostForm;
import com.arsdigita.forum.ui.RootPostForm;
import com.arsdigita.forum.ui.Text;
import com.arsdigita.forum.ui.ThreadsList;
import com.arsdigita.forum.ui.TopicSelector;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.toolbox.ui.SecurityContainer;
import org.apache.log4j.Logger;

public class ThreadsPanel
extends SimpleContainer
implements Constants {
    private static Logger s_log = Logger.getLogger(ThreadsPanel.class);
    private ModalContainer m_mode = new ModalContainer();
    private Component m_threadsListing;
    private PostForm m_postComponent;
    private ToggleLink m_newThreadLink;
    private StringParameter m_newPostParam;

    public ThreadsPanel() {
        this.add((Component)this.m_mode);
        this.m_threadsListing = this.createThreadsListing();
        this.m_postComponent = this.createNewThreadForm();
        this.m_mode.add(this.m_threadsListing);
        this.m_mode.add((Component)this.m_postComponent);
        this.m_mode.setDefaultComponent(this.m_threadsListing);
    }

    public void register(Page p) {
        super.register(p);
        p.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                s_log.debug((Object)"create link pressed");
                PageState s = e.getPageState();
                if (ThreadsPanel.this.m_newThreadLink.isSelected(s)) {
                    ThreadsPanel.this.m_postComponent.setContext(s, "new");
                    ThreadsPanel.this.m_mode.setVisibleComponent(s, (Component)ThreadsPanel.this.m_postComponent);
                } else {
                    ThreadsPanel.this.m_mode.setVisibleComponent(s, ThreadsPanel.this.m_threadsListing);
                }
            }
        });
    }

    private Component createThreadsListing() {
        SimpleContainer forums = new SimpleContainer();
        SimpleContainer forumOptions = new SimpleContainer("forum:forumOptions", "http://www.arsdigita.com/forum/1.0");
        this.m_newThreadLink = new ToggleLink((Component)new Label(Text.gz("forum.ui.thread.newPost")));
        this.m_newThreadLink.setClassAttr("actionLink");
        SecurityContainer sc = new SecurityContainer((Component)this.m_newThreadLink){

            protected boolean canAccess(Party party, PageState state) {
                Forum forum = ForumContext.getContext(state).getForum();
                PermissionDescriptor createThread = new PermissionDescriptor(PrivilegeDescriptor.get((String)"forum_create_thread"), (ACSObject)forum, party);
                return PermissionService.checkPermission((PermissionDescriptor)createThread);
            }
        };
        forumOptions.add((Component)sc);
        forums.add((Component)forumOptions);
        TopicSelector topics = new TopicSelector();
        forums.add((Component)topics);
        ThreadsList threads = new ThreadsList();
        forums.add((Component)threads);
        return forums;
    }

    private PostForm createNewThreadForm() {
        RootPostForm editForm = new RootPostForm();
        editForm.addCompletionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThreadsPanel.this.editPageStateCleanup(e.getPageState());
            }
        });
        return editForm;
    }

    private void editPageStateCleanup(PageState state) {
        this.m_newThreadLink.setSelected(state, false);
        ForumContext.getContext(state).setCategorySelection(Constants.TOPIC_ANY);
    }
}

