/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui.admin;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormStep;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Wizard;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.EmailValidationListener;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.mail.Mail;
import com.arsdigita.messaging.Message;
import com.arsdigita.messaging.MessageThread;
import com.arsdigita.messaging.ThreadedMessage;
import com.arsdigita.notification.Notification;
import com.arsdigita.util.HtmlToText;
import com.arsdigita.util.StringUtils;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import org.apache.log4j.Logger;

public class RejectionForm
extends Wizard
implements Constants {
    private static final Logger s_log = Logger.getLogger(RejectionForm.class);
    private ACSObjectSelectionModel m_postModel;
    private Label m_recipientLabel;
    private TextField m_recipient;
    private TextArea m_textArea;
    protected static final String ALERT_BLURB = "This is an automated notice from the Discussion Forum system. ";
    protected static final String SEPARATOR = "\n\n" + StringUtils.repeat((char)'-', (int)20) + "\n\n";
    protected static final String HTML_SEPARATOR = "<hr>";

    public RejectionForm(ACSObjectSelectionModel postModel) {
        super("postRejectionForm");
        this.m_postModel = postModel;
        this.add((Container)this.dataEntryStep());
        this.add(this.confirmStep());
        this.addInitListener(new RejectionInitListener());
        this.addProcessListener(new RejectionProcessListener());
    }

    private FormStep dataEntryStep() {
        FormStep form = new FormStep("initial", (Container)new BoxPanel(2));
        this.m_recipientLabel = new Label("Recipient Email (Optional)");
        form.add((Component)this.m_recipientLabel);
        this.m_recipient = new TextField("recipient");
        this.m_recipient.addValidationListener((ParameterListener)new EmailValidationListener(){

            public void validate(ParameterEvent e) throws FormProcessException {
                if (!StringUtils.emptyString((Object)RejectionForm.this.m_recipient.getValue(e.getPageState()))) {
                    super.validate(e);
                }
            }
        });
        this.m_recipient.setMetaDataAttribute("label", "Recipient email(optional)");
        form.add((Component)this.m_recipient);
        form.add((Component)new Label("Message"));
        this.m_textArea = new TextArea("bodyText");
        this.m_textArea.setMetaDataAttribute("label", "Message");
        form.add((Component)this.m_textArea);
        return form;
    }

    private Container confirmStep() {
        BoxPanel confirm = new BoxPanel(2);
        Label subject = new Label(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState state = e.getPageState();
                Post post = (Post)RejectionForm.this.m_postModel.getSelectedObject(state);
                Label l = (Label)e.getTarget();
                l.setOutputEscaping(false);
                l.setLabel(RejectionForm.this.getHeader(post));
            }
        });
        Label body = new Label(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState state = e.getPageState();
                Post post = (Post)RejectionForm.this.m_postModel.getSelectedObject(state);
                Label l = (Label)e.getTarget();
                l.setOutputEscaping(false);
                l.setLabel(RejectionForm.this.getBody(post, state));
            }
        });
        Label sig = new Label(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState state = e.getPageState();
                Post post = (Post)RejectionForm.this.m_postModel.getSelectedObject(state);
                Label l = (Label)e.getTarget();
                l.setOutputEscaping(false);
                l.setLabel(Mail.getConfig().sendHTMLMessageAsHTMLEmail() ? RejectionForm.this.getHTMLSignature() : StringUtils.replace((String)RejectionForm.this.getSignature(), (String)"\n", (String)"<br>"));
            }
        });
        confirm.add((Component)subject);
        confirm.add((Component)body);
        confirm.add((Component)sig);
        return confirm;
    }

    private String getHeader(Post post) {
        StringBuffer header = new StringBuffer();
        header.append("Forum    : ");
        header.append(post.getForum().getDisplayName()).append("<br>");
        header.append("Subject  : ");
        header.append(post.getSubject()).append("<br><br>");
        return header.toString();
    }

    private String getBody(Post post, PageState state) {
        StringBuffer body = new StringBuffer();
        body.append("<br><br>Your message has been rejected by the moderator.<br><br>");
        body.append("The moderator has given the following reasons:<br><br>");
        body.append((String)this.m_textArea.getValue(state));
        body.append("<br><br>");
        body.append("The content of the message follows:<br><br>");
        body.append("Subject: " + post.getSubject() + "<br>");
        body.append(post.getBody() + "<br><br><br>");
        String instructions = Forum.getConfig().getRejectionMessage();
        if (instructions != null) {
            body.append(instructions);
            body.append("<br><br>");
        }
        return body.toString();
    }

    private String getSignature() {
        StringBuffer sig = new StringBuffer();
        sig.append(SEPARATOR);
        sig.append(ALERT_BLURB);
        return sig.toString();
    }

    private String getHTMLSignature() {
        StringBuffer sig = new StringBuffer();
        sig.append(HTML_SEPARATOR);
        sig.append(ALERT_BLURB);
        return sig.toString();
    }

    private class RejectionProcessListener
    implements FormProcessListener {
        private RejectionProcessListener() {
        }

        public void process(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            Post post = (Post)RejectionForm.this.m_postModel.getSelectedObject(state);
            MessageThread thread = ForumContext.getContext(state).getMessageThread();
            ThreadedMessage root = thread.getRootMessage();
            if (RejectionForm.this.getFinish().isSelected(state)) {
                if (post.equals(root)) {
                    s_log.debug((Object)"Suppressing entire thread");
                    post.setStatus("suppressed");
                } else {
                    s_log.debug((Object)"rejecting message");
                    post.setStatus("rejected");
                }
                post.save();
                String msg = (String)RejectionForm.this.m_textArea.getValue(state);
                if (msg != null && !"".equals(msg.trim())) {
                    this.sendNotice(post, state);
                } else {
                    s_log.info((Object)"Skipping notification because message is empty");
                }
            }
            RejectionForm.this.fireCompletionEvent(state);
        }

        private void sendNotice(Post post, PageState state) {
            Forum forum = ForumContext.getContext(state).getForum();
            Group noticeSender = forum.getModerationGroup();
            if (noticeSender == null) {
                noticeSender = post.getModerator();
            }
            StringBuffer rejectionNoticeBody = new StringBuffer();
            rejectionNoticeBody.append(RejectionForm.this.getHeader(post));
            rejectionNoticeBody.append(RejectionForm.this.getBody(post, state));
            StringBuffer nonHTMLRejectionNotice = new StringBuffer(new HtmlToText().convert(rejectionNoticeBody.toString()));
            rejectionNoticeBody.append(RejectionForm.this.getHTMLSignature());
            nonHTMLRejectionNotice.append(RejectionForm.this.getSignature());
            if (!StringUtils.emptyString((Object)RejectionForm.this.m_recipient.getValue(state))) {
                Mail mailMessage = new Mail();
                mailMessage.setTo((String)RejectionForm.this.m_recipient.getValue(state));
                mailMessage.setFrom(noticeSender.getPrimaryEmail().getEmailAddress());
                mailMessage.setSubject("Moderation notice " + post.getForum().getDisplayName());
                if (Mail.getConfig().sendHTMLMessageAsHTMLEmail()) {
                    rejectionNoticeBody.append(RejectionForm.this.getHTMLSignature());
                    mailMessage.setBody(rejectionNoticeBody.toString(), nonHTMLRejectionNotice.toString());
                } else {
                    mailMessage.setBody(nonHTMLRejectionNotice.toString());
                }
                try {
                    mailMessage.send();
                }
                catch (SendFailedException e) {
                    s_log.error((Object)("Couldn't send forum post rejection message for post " + post.getID()), (Throwable)e);
                }
                catch (MessagingException e) {
                    s_log.error((Object)("Couldn't send forum post rejection message for post " + post.getID()), (Throwable)e);
                }
                return;
            }
            if (!post.getFrom().equals((Object)Kernel.getPublicUser())) {
                Notification notice = new Notification();
                notice.setTo(post.getFrom());
                notice.setHeader(RejectionForm.this.getHeader(post));
                Message message = new Message();
                message.setFrom((Party)noticeSender);
                message.setSubject("Moderation notice " + post.getForum().getDisplayName());
                if (Mail.getConfig().sendHTMLMessageAsHTMLEmail()) {
                    notice.setHeader(RejectionForm.this.getHeader(post));
                    message.setBody(RejectionForm.this.getBody(post, state), "text/html");
                    notice.setSignature(RejectionForm.this.getHTMLSignature());
                } else {
                    notice.setHeader(new HtmlToText().convert(RejectionForm.this.getHeader(post)));
                    message.setBody(new HtmlToText().convert(RejectionForm.this.getBody(post, state)), "text/plain");
                    notice.setSignature(RejectionForm.this.getSignature());
                }
                notice.setMessage(message);
                s_log.debug((Object)("sending notification" + message + "\n to: " + post.getFrom().getName()));
            }
        }
    }

    private class RejectionInitListener
    implements FormInitListener {
        private RejectionInitListener() {
        }

        public void init(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            RejectionForm.this.m_textArea.setValue(state, (Object)"");
            RejectionForm.this.m_recipient.setValue(state, (Object)"");
            if (!ForumContext.getContext(state).getForum().anonymousPostsAllowed()) {
                RejectionForm.this.m_recipientLabel.setVisible(state, false);
                RejectionForm.this.m_recipient.setVisible(state, false);
            }
        }
    }
}

