/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui.admin;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.persistence.DataQuery;
import java.math.BigDecimal;

public abstract class UserPicker
extends FormSection
implements FormProcessListener,
FormInitListener {
    private static final int USER_LIST_SIZE = 10;
    private static final String ADD_USER = "addUser";
    private StringParameter m_nameParam;
    private TextField m_name;
    private List m_userList;
    private Paginator m_pg;
    private String m_context;

    public UserPicker() {
        this("");
    }

    public UserPicker(String context) {
        this.m_context = context;
        this.addWidgets();
        this.addDisplay();
        this.addProcessListener(this);
        this.addInitListener(this);
    }

    protected void addWidgets() {
        this.m_nameParam = new StringParameter(this.m_context + "name");
        BoxPanel attrs = new BoxPanel(1);
        Label nameLab = new Label("Name");
        this.m_name = new TextField(this.m_context + "name1");
        attrs.add((Component)nameLab);
        attrs.add((Component)this.m_name);
        attrs.add((Component)new Submit("search", "Search"));
        this.add((Component)attrs);
    }

    protected void addDisplay() {
        BoxPanel attrs = new BoxPanel(2);
        this.m_userList = new List();
        this.m_userList.setModelBuilder((ListModelBuilder)new UserListModelBuilder());
        this.m_userList.setCellRenderer((ListCellRenderer)new UserListCellRenderer());
        this.m_pg = new Paginator((PaginationModelBuilder)this.m_userList.getModelBuilder(), 10);
        this.m_userList.addActionListener((ActionListener)new UserActionListener());
        attrs.add((Component)this.m_pg);
        attrs.add((Component)this.m_userList);
        this.add((Component)attrs);
    }

    private void setListVisible(PageState ps, boolean state) {
        this.m_userList.setVisible(ps, state);
        this.m_pg.setVisible(ps, state);
    }

    public void init(FormSectionEvent e) {
        PageState ps = e.getPageState();
        this.m_name.setValue(ps, ps.getValue((ParameterModel)this.m_nameParam));
    }

    public void process(FormSectionEvent e) {
        PageState ps = e.getPageState();
        ps.setValue((ParameterModel)this.m_nameParam, this.m_name.getValue(ps));
        this.m_pg.reset(ps);
        this.setListVisible(ps, ps.getValue((ParameterModel)this.m_nameParam) != null);
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault((Component)this.m_userList, false);
        p.setVisibleDefault((Component)this.m_pg, false);
        p.addGlobalStateParam((ParameterModel)this.m_nameParam);
    }

    protected abstract DataQuery getUsers(PageState var1, String var2);

    protected abstract String getDisplayName(DataQuery var1);

    protected abstract String getKey(DataQuery var1);

    protected abstract void addUser(PageState var1, BigDecimal var2);

    private class UserActionListener
    implements ActionListener {
        private UserActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String key = (String)UserPicker.this.m_userList.getSelectedKey(e.getPageState());
            UserPicker.this.addUser(e.getPageState(), new BigDecimal(key));
            UserPicker.this.setListVisible(e.getPageState(), false);
            UserPicker.this.m_pg.reset(e.getPageState());
        }
    }

    private class UserListCellRenderer
    implements ListCellRenderer {
        private UserListCellRenderer() {
        }

        public Component getComponent(List l, PageState ps, Object value, String key, int index, boolean isSelected) {
            return new ControlLink(value.toString());
        }
    }

    private class UserListModel
    implements ListModel {
        private DataQuery m_query;

        public UserListModel(DataQuery query) {
            this.m_query = query;
        }

        public Object getElement() {
            return UserPicker.this.getDisplayName(this.m_query);
        }

        public String getKey() {
            return UserPicker.this.getKey(this.m_query);
        }

        public boolean next() {
            return this.m_query.next();
        }
    }

    private class UserListModelBuilder
    implements ListModelBuilder,
    PaginationModelBuilder {
        private boolean m_locked = false;
        private RequestLocal m_query = new RequestLocal();

        private UserListModelBuilder() {
        }

        public boolean isLocked() {
            return this.m_locked;
        }

        public void lock() {
            this.m_locked = true;
        }

        public boolean isVisible(PageState ps) {
            return UserPicker.this.m_userList.isVisible(ps);
        }

        public int getTotalSize(Paginator pg, PageState ps) {
            DataQuery query = this.getDataQuery(ps);
            if (query == null) {
                return 0;
            }
            return (int)query.size();
        }

        private DataQuery getDataQuery(PageState state) {
            return UserPicker.this.getUsers(state, (String)state.getValue((ParameterModel)UserPicker.this.m_nameParam));
        }

        public ListModel makeModel(List l, PageState ps) {
            DataQuery q = this.getDataQuery(ps);
            if (q == null) {
                return List.EMPTY_MODEL;
            }
            q.setRange(new Integer(UserPicker.this.m_pg.getFirst(ps)), new Integer(UserPicker.this.m_pg.getLast(ps) + 1));
            return new UserListModel(q);
        }
    }
}

