/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.MultipleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.bebop.parameters.URLParameter;
import com.arsdigita.bebop.util.Color;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionCollection;
import com.arsdigita.cms.docmgr.DocFolder;
import com.arsdigita.cms.docmgr.DocLink;
import com.arsdigita.cms.docmgr.DocMgr;
import com.arsdigita.cms.docmgr.search.SearchResults;
import com.arsdigita.cms.docmgr.search.SearchUtils;
import com.arsdigita.cms.docmgr.ui.BrowsePane;
import com.arsdigita.cms.docmgr.ui.CategoriesPrintListener;
import com.arsdigita.cms.docmgr.ui.CreateDocLinkSearchTable;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.DMUtils;
import com.arsdigita.cms.docmgr.ui.SearchForm;
import com.arsdigita.dispatcher.ObjectNotFoundException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.TooManyListenersException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class CreateDocLinkPane
extends SimpleContainer
implements DMConstants {
    private static final Logger s_log = Logger.getLogger((String)CreateDocLinkPane.class.getName());
    public static final String PARAM_EDIT_DOCLINK_ID = "editDoclinkID";
    private static final String SEARCH_DOCUMENT = "searchDocument";
    private static final String TITLE = "title";
    private static final String DESCRIPTION = "description";
    private static final String EXTERNAL_URL = "url";
    private static final String CATEGORIES = "file-edit-cats";
    private final BigDecimalParameter m_doclinkIDParam = new BigDecimalParameter("editDoclinkID");
    private final TrimmedStringParameter m_searchDocsParam = new TrimmedStringParameter("searchDocument");
    private Label m_emptyLabel;
    private Label m_errorMessages;
    private Tree m_tree;
    private Paginator m_paginator;

    public CreateDocLinkPane(Component parent, Tree tree) {
        this.m_tree = tree;
        ColumnPanel m_mainContainer = new ColumnPanel(1);
        this.add((Component)new Label(" "));
        this.add((Component)new Label(" "));
        this.add((Component)new Label(new GlobalizedMessage("ui.link.create.explanation", "com.arsdigita.cms.docmgr.ui.DMResources")), 1);
        URLEntryForm m_entryForm = new URLEntryForm((Container)new GridPanel(2), parent);
        m_mainContainer.add((Component)m_entryForm);
        m_mainContainer.add((Component)new Label(" "));
        m_mainContainer.add((Component)new Label(" "));
        DocumentSearchForm topSearchForm = new DocumentSearchForm((Container)new GridPanel(2));
        m_mainContainer.add((Component)topSearchForm);
        m_mainContainer.add((Component)new Label(" &nbsp; &nbsp; ", false));
        SegmentedPanel bottom = new SegmentedPanel();
        bottom.setClassAttr("main");
        ModalContainer m_segmentHeader = new ModalContainer();
        this.m_emptyLabel = new Label("Search Results");
        m_segmentHeader.add((Component)this.m_emptyLabel);
        m_segmentHeader.setDefaultComponent((Component)this.m_emptyLabel);
        final CreateDocLinkSearchTable m_search = new CreateDocLinkSearchTable(this, parent, tree, topSearchForm);
        m_entryForm.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent e) throws FormProcessException {
                m_search.clearSelection(e.getPageState());
                e.getPageState().setValue((ParameterModel)CreateDocLinkPane.this.m_searchDocsParam, null);
            }
        });
        this.m_paginator = new Paginator((PaginationModelBuilder)m_search.getModelBuilder(), 10);
        bottom.addSegment((Component)m_segmentHeader, (Component)this.m_paginator);
        this.m_paginator.setHiddenIfSinglePage(false);
        m_mainContainer.add((Component)bottom);
        this.m_errorMessages = new Label("");
        this.m_errorMessages.setColor(Color.red);
        m_mainContainer.add((Component)this.m_errorMessages);
        m_mainContainer.add((Component)m_search);
        this.add((Component)m_mainContainer);
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_doclinkIDParam);
        p.addGlobalStateParam((ParameterModel)this.m_searchDocsParam);
    }

    Label getErrorLable() {
        return this.m_errorMessages;
    }

    public BigDecimalParameter getEditDoclinkIDParam() {
        return this.m_doclinkIDParam;
    }

    private DocFolder getSelectedFolder(PageState state) {
        DocFolder p = null;
        String selKey = (String)this.m_tree.getSelectedKey(state);
        if (selKey == null) {
            p = DMUtils.getRootFolder(state);
        } else {
            BigDecimal folderID = new BigDecimal(selKey);
            try {
                p = new DocFolder(folderID);
            }
            catch (DataObjectNotFoundException nf) {
                throw new ObjectNotFoundException((String)FOLDER_PARENTNOTFOUND_ERROR.localize(state.getRequest()));
            }
        }
        return p;
    }

    private class DocumentSearchForm
    extends Form
    implements SearchForm,
    FormValidationListener,
    FormProcessListener,
    FormInitListener {
        private Submit m_submit;
        private RequestLocal m_validated;
        private RequestLocal m_coln;

        public DocumentSearchForm(Container panel) {
            super("docSearch", panel);
            this.setMethod("get");
            this.add((Component)new Label("Search text:"));
            TextField searchText = new TextField(CreateDocLinkPane.SEARCH_DOCUMENT);
            this.add((Component)searchText);
            this.m_submit = new Submit("search", "Search");
            this.add((Component)this.m_submit);
            this.addValidationListener(this);
            this.addProcessListener(this);
            this.addInitListener(this);
            this.m_coln = new RequestLocal();
            this.m_validated = new RequestLocal();
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            e.getFormData().setParameter(CreateDocLinkPane.SEARCH_DOCUMENT, null);
        }

        public void validate(FormSectionEvent e) throws FormProcessException {
            PageState ps = e.getPageState();
            String docsSearch = (String)ps.getValue((ParameterModel)CreateDocLinkPane.this.m_searchDocsParam);
            if (StringUtils.emptyString((String)docsSearch)) {
                CreateDocLinkPane.this.m_emptyLabel.setVisible(ps, true);
                this.m_validated.set(ps, (Object)new Boolean(false));
                throw new FormProcessException("At least one search parameter must be specified");
            }
            this.m_validated.set(ps, (Object)new Boolean(true));
            CreateDocLinkPane.this.m_paginator.reset(ps);
        }

        public void process(FormSectionEvent e) {
            PageState state = e.getPageState();
            if (this.m_submit.isSelected(state) && ((Boolean)this.m_validated.get(state)).booleanValue()) {
                SearchResults results = this.getSearchHits(state);
                if (results != null && results.getTotalSize() > 0L) {
                    s_log.debug((Object)"results");
                } else {
                    s_log.debug((Object)"no results");
                }
            }
        }

        @Override
        public SearchResults getSearchHits(PageState state) {
            SearchResults searchResults = (SearchResults)this.m_coln.get(state);
            String terms = (String)state.getValue((ParameterModel)CreateDocLinkPane.this.m_searchDocsParam);
            s_log.debug((Object)("terms is " + terms));
            if (searchResults == null && !StringUtils.emptyString((String)terms)) {
                User user = KernelHelper.getCurrentUser((HttpServletRequest)state.getRequest());
                searchResults = SearchUtils.getSimpleSearch(terms, user);
                this.m_coln.set(state, (Object)searchResults);
            }
            return searchResults;
        }

        @Override
        public boolean isVisible(PageState state) {
            return true;
        }

        @Override
        public long getSearchResultCount(PageState state) {
            return this.m_coln.get(state) == null ? 0L : ((SearchResults)this.m_coln.get(state)).getTotalSize();
        }
    }

    private class URLEntryForm
    extends Form
    implements FormInitListener,
    FormValidationListener,
    FormProcessListener {
        private Submit m_submit;
        TrimmedStringParameter m_title;
        TrimmedStringParameter m_description;
        URLParameter m_URL;
        ArrayParameter m_cats;
        Component m_parent;

        public URLEntryForm(Container panel, Component parent) {
            super("urlEntry", panel);
            this.setMethod("post");
            this.m_parent = parent;
            this.m_title = new TrimmedStringParameter(CreateDocLinkPane.TITLE);
            this.m_description = new TrimmedStringParameter(CreateDocLinkPane.DESCRIPTION);
            this.m_URL = new URLParameter(CreateDocLinkPane.EXTERNAL_URL);
            this.add((Component)new Label("Title:"));
            TextField title = new TextField((ParameterModel)this.m_title);
            this.add((Component)title);
            this.add((Component)new Label("Description (optional):"));
            TextArea desc = new TextArea((ParameterModel)this.m_description);
            desc.setRows(10);
            desc.setCols(40);
            this.add((Component)desc);
            this.add((Component)new Label("URL (must begin with \"http://\" or \"https://\"):"));
            TextField url = new TextField((ParameterModel)this.m_URL);
            url.setSize(70);
            this.add((Component)url);
            this.add((Component)new Label(DMConstants.FILE_CATEGORIES));
            this.m_cats = new ArrayParameter(CreateDocLinkPane.CATEGORIES);
            MultipleSelect catSelect = new MultipleSelect(CreateDocLinkPane.CATEGORIES);
            catSelect.setSize(20);
            try {
                catSelect.addPrintListener((PrintListener)new CategoriesPrintListener(this.getContentSection(), CreateDocLinkPane.this.getEditDoclinkIDParam()));
            }
            catch (TooManyListenersException tmex) {
                throw new UncheckedWrapperException(tmex.getMessage());
            }
            this.add((Component)catSelect);
            this.m_submit = new Submit("submitButton", "Save Link");
            this.add((Component)this.m_submit, 4);
            this.add((Component)new Submit("cancelButton", "Cancel"));
            this.addInitListener(this);
            this.addValidationListener(this);
            this.addProcessListener(this);
        }

        private ContentSection getContentSection() {
            ContentSectionCollection csc = ContentSection.getAllSections();
            csc.addEqualsFilter("label", (Object)DocMgr.getConfig().getContentSection());
            if (!csc.next()) {
                csc.close();
                return null;
            }
            ContentSection cs = csc.getContentSection();
            csc.close();
            return cs;
        }

        public void init(FormSectionEvent e) {
            PageState state = e.getPageState();
            BigDecimal id = (BigDecimal)state.getValue((ParameterModel)CreateDocLinkPane.this.m_doclinkIDParam);
            if (id != null) {
                DocLink doclink = new DocLink(id);
                FormData fd = e.getFormData();
                if (doclink.isExternal()) {
                    fd.put((Object)CreateDocLinkPane.TITLE, (Object)doclink.getTitle());
                    fd.put((Object)CreateDocLinkPane.DESCRIPTION, (Object)doclink.getDescription());
                    fd.put((Object)CreateDocLinkPane.EXTERNAL_URL, (Object)doclink.getExternalURL());
                    ArrayList<String> assignedCats = new ArrayList<String>();
                    CategoryCollection cats = doclink.getCategoryCollection();
                    if (cats.next()) {
                        Category cat = cats.getCategory();
                        String catID = cat.getID().toString();
                        assignedCats.add(catID);
                    }
                    fd.put((Object)CreateDocLinkPane.CATEGORIES, (Object)assignedCats.toArray());
                }
            }
        }

        public void validate(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            if (this.m_submit.isSelected(state)) {
                String url;
                FormData fd = e.getFormData();
                String title = (String)fd.get((Object)CreateDocLinkPane.TITLE);
                if (title == null || title.trim().length() == 0) {
                    fd.addError(CreateDocLinkPane.TITLE, "This parameter is required");
                }
                if (title != null && title.length() > 1000) {
                    fd.addError(CreateDocLinkPane.TITLE, "This parameter is too long. It must be fewer than 1000 characters.");
                }
                if ((url = (String)fd.get((Object)CreateDocLinkPane.EXTERNAL_URL)) == null || url.trim().length() == 0) {
                    fd.addError(CreateDocLinkPane.EXTERNAL_URL, "This parameter is required");
                }
                if (url != null && url.length() > 4000) {
                    fd.addError(CreateDocLinkPane.EXTERNAL_URL, "This parameter is too long. It must be fewer than 4000 characters.");
                }
                try {
                    new URL(url);
                }
                catch (MalformedURLException ex) {
                    fd.addError(CreateDocLinkPane.EXTERNAL_URL, "Please enter a URL");
                }
                String desc = (String)fd.get((Object)CreateDocLinkPane.DESCRIPTION);
                if (desc != null && desc.length() > 4000) {
                    fd.addError(CreateDocLinkPane.DESCRIPTION, "This parameter is too long. It must be fewer than 4000 characters.");
                }
            }
        }

        public void process(FormSectionEvent e) {
            PageState state = e.getPageState();
            FormData fd = e.getFormData();
            if (this.m_submit.isSelected(state)) {
                DocLink link;
                final DocFolder parent = CreateDocLinkPane.this.getSelectedFolder(state);
                BigDecimal id = (BigDecimal)state.getValue((ParameterModel)CreateDocLinkPane.this.m_doclinkIDParam);
                if (id != null) {
                    link = new DocLink(id);
                    ContentBundle bundle = link.getContentBundle();
                } else {
                    link = new DocLink();
                    link.setName((String)fd.get((Object)CreateDocLinkPane.TITLE));
                    link.setRepository(DocFolder.getRepository(parent));
                    link.setLanguage("en");
                    ContentBundle bundle = new ContentBundle((ContentItem)link);
                    bundle.setParent((ACSObject)parent);
                    bundle.setContentSection(parent.getContentSection());
                    bundle.save();
                    final ContentBundle bundleFinal = bundle;
                    new KernelExcursion(){

                        protected void excurse() {
                            this.setParty(Kernel.getSystemParty());
                            PermissionService.setContext((ACSObject)bundleFinal, (ACSObject)parent);
                        }
                    }.run();
                }
                link.setName((String)fd.get((Object)CreateDocLinkPane.TITLE));
                link.setTitle((String)fd.get((Object)CreateDocLinkPane.TITLE));
                link.setDescription((String)fd.get((Object)CreateDocLinkPane.DESCRIPTION));
                link.setExternalURL((String)fd.get((Object)CreateDocLinkPane.EXTERNAL_URL));
                link.setCategories((String[])fd.get((Object)CreateDocLinkPane.CATEGORIES));
            }
            ((BrowsePane)this.m_parent).displayFolderContentPanel(state);
        }
    }
}

