/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.EmailValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.FileInfoPropertiesPane;
import com.arsdigita.cms.docmgr.ui.SearchPane;
import com.arsdigita.kernel.User;
import com.arsdigita.mail.Mail;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.web.Web;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;

class FileSendColleaguePane
extends SimpleContainer
implements DMConstants {
    private static final Logger s_log = Logger.getLogger(SearchPane.class);
    private final FileInfoPropertiesPane m_parent;
    private static final String EMAIL_PARAM_NAME = "scEmail";
    private final TrimmedStringParameter m_emailParam = new TrimmedStringParameter("scEmail");
    private Component m_sendForm;
    private Component m_thankYou;

    FileSendColleaguePane(FileInfoPropertiesPane parent) {
        this.m_parent = parent;
        GridPanel spacer = new GridPanel(1);
        spacer.add((Component)new Label("   "));
        this.add((Component)spacer);
        this.m_sendForm = new SendForm();
        this.add(this.m_sendForm);
        this.m_thankYou = this.buildThankYou();
        this.add(this.m_thankYou);
    }

    public void initState(PageState ps) {
        this.m_sendForm.setVisible(ps, true);
        this.m_thankYou.setVisible(ps, false);
    }

    private Component buildThankYou() {
        BoxPanel panel = new BoxPanel();
        panel.add((Component)FILE_SEND_COLLEAGUE_THANKS);
        ActionLink backLink = new ActionLink(FILE_SEND_COLLEAGUE_THANKS_RETURN_LINK.localize().toString());
        backLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                FileSendColleaguePane.this.m_parent.displayPropertiesAndActions(state);
            }
        });
        panel.add((Component)backLink);
        return panel;
    }

    private class SendForm
    extends Form
    implements FormProcessListener {
        public SendForm() {
            super("sendEmail", (Container)new BoxPanel());
            GridPanel panel = new GridPanel(2);
            panel.add((Component)DMConstants.FILE_SEND_COLLEAGUE_FORM_EMAIL);
            TextField emailField = new TextField((ParameterModel)FileSendColleaguePane.this.m_emailParam);
            emailField.addValidationListener((ParameterListener)new EmailValidationListener());
            panel.add((Component)emailField, 1);
            panel.add((Component)new Submit(DMConstants.FILE_SEND_COLLEAGUE_SUBMIT));
            this.add((Component)panel);
            this.addProcessListener(this);
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            FormData data = e.getFormData();
            this.setVisible(state, false);
            FileSendColleaguePane.this.m_thankYou.setVisible(state, true);
            User u = Web.getContext().getUser();
            s_log.debug((Object)DMConstants.FILE_SEND_COLLEAGUE_RETURN_ADDRESS.localize().toString());
            Mail mail = new Mail((String)data.get((Object)FileSendColleaguePane.EMAIL_PARAM_NAME), DMConstants.FILE_SEND_COLLEAGUE_RETURN_ADDRESS.localize().toString(), DMConstants.FILE_SEND_COLLEAGUE_SUBJECT.localize().toString(), DMConstants.FILE_SEND_COLLEAGUE_MESSAGE.localize().toString() + " " + u.getName());
            Document doc = new Document((BigDecimal)state.getValue((ParameterModel)FileSendColleaguePane.this.m_parent.getFileIDParam()));
            try {
                FileAsset fa = doc.getFile();
                if (fa == null) {
                    return;
                }
                ByteArrayOutputStream assetStream = new ByteArrayOutputStream();
                long readBytes = fa.writeBytes((OutputStream)assetStream);
                if (readBytes == 0L) {
                    return;
                }
                String mimeTypeString = "application/octet-stream";
                MimeType mimeType = fa.getMimeType();
                if (mimeType != null) {
                    mimeTypeString = mimeType.getMimeType();
                }
                s_log.debug((Object)("mimeTypeString: " + mimeTypeString));
                mail.attach(assetStream.toByteArray(), mimeTypeString, doc.getTitle());
                mail.send();
            }
            catch (IOException iox) {
                iox.printStackTrace();
                throw new FormProcessException("An error occurred while trying to send document");
            }
            catch (MessagingException mex) {
                mex.printStackTrace();
                throw new FormProcessException("An error occurred while trying to send document");
            }
        }
    }
}

