/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormValidationException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.docmgr.DocFolder;
import com.arsdigita.cms.docmgr.ResourceExistsException;
import com.arsdigita.cms.docmgr.Util;
import com.arsdigita.cms.docmgr.ui.BrowsePane;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.DMUtils;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.permissions.PermissionService;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;

class FolderCreateForm
extends Form
implements FormInitListener,
FormValidationListener,
FormProcessListener,
DMConstants {
    private StringParameter m_FolderName;
    private StringParameter m_FolderDesc;
    private Tree m_tree;
    private BrowsePane m_parent;
    private Submit m_submit;

    public FolderCreateForm(BrowsePane parent, Tree tree) {
        super("CreateFolderForm", (Container)new ColumnPanel(2));
        this.m_parent = parent;
        this.m_tree = tree;
        this.add((Component)FOLDER_NAME_LABEL);
        this.m_FolderName = new StringParameter("folder-name");
        TextField fnameEntry = new TextField((ParameterModel)this.m_FolderName);
        this.add((Component)fnameEntry);
        this.add((Component)FOLDER_DESCRIPTION_LABEL);
        this.m_FolderDesc = new StringParameter("folder-description");
        TextArea textArea = new TextArea((ParameterModel)this.m_FolderDesc);
        textArea.setRows(10);
        textArea.setCols(40);
        this.add((Component)textArea);
        SimpleContainer sc = new SimpleContainer();
        this.m_submit = new Submit("submit");
        this.m_submit.setButtonLabel(FOLDER_SAVE);
        sc.add((Component)this.m_submit);
        Submit cancel = new Submit(CANCEL);
        sc.add((Component)cancel);
        this.add((Component)new Label());
        this.add((Component)sc, 1);
        this.addInitListener(this);
        this.addProcessListener(this);
        this.addValidationListener(this);
    }

    public void init(FormSectionEvent e) {
        PageState state = e.getPageState();
        if (Kernel.getContext().getParty() == null) {
            Util.redirectToLoginPage(state);
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        BigDecimal createdFolderID = null;
        if (this.m_submit.isSelected(state)) {
            FormData data = e.getFormData();
            String fname = (String)data.get((Object)"folder-name");
            String fdesc = (String)data.get((Object)"folder-description");
            String selKey = (String)this.m_tree.getSelectedKey(state);
            DocFolder p = null;
            if (selKey == null) {
                p = DMUtils.getRootFolder(state);
            } else {
                BigDecimal folderID = new BigDecimal(selKey);
                try {
                    p = new DocFolder(folderID);
                }
                catch (DataObjectNotFoundException nf) {
                    throw new RuntimeException("Could not find folder");
                }
            }
            final DocFolder parent = p;
            final DocFolder folder = new DocFolder(fname, fdesc, parent);
            try {
                folder.save();
            }
            catch (ResourceExistsException ree) {
                throw new FormValidationException("A folder with this name already exists.");
            }
            new KernelExcursion(){

                protected void excurse() {
                    this.setParty(Kernel.getSystemParty());
                    PermissionService.setContext((ACSObject)folder, (ACSObject)parent);
                }
            }.run();
            createdFolderID = folder.getID();
        }
        if (this.m_parent != null) {
            this.m_parent.setCreatedFolderID(state, createdFolderID);
            this.m_parent.displayFolderContentPanel(state);
        }
    }

    public void validate(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        if (this.m_submit.isSelected(state)) {
            String fDesc;
            FormData data = event.getFormData();
            HttpServletRequest req = state.getRequest();
            String fname = (String)data.get((Object)"folder-name");
            if (fname == null || fname.trim().length() == 0) {
                data.addError("folder-name", "This parameter is required");
            }
            if (fname != null && fname.length() > 200) {
                data.addError("folder-name", "This parameter is too long. It must be fewer than 200 characters.");
            }
            if ((fDesc = (String)data.get((Object)"folder-description")) != null && fDesc.length() > 4000) {
                data.addError("folder-description", "This parameter is too long. It must be fewer than 4000 characters.");
            }
            DocFolder parent = null;
            String selKey = (String)this.m_tree.getSelectedKey(state);
            if (selKey == null) {
                parent = DMUtils.getRootFolder(state);
                if (parent == null) {
                    data.addError("folder-name", (String)FOLDER_PARENTNOTFOUND_ERROR.localize(req));
                }
            } else {
                BigDecimal folderID = new BigDecimal(selKey);
                try {
                    parent = new DocFolder(folderID);
                }
                catch (DataObjectNotFoundException nf) {
                    data.addError("folder-name", (String)FOLDER_PARENTNOTFOUND_ERROR.localize(req));
                }
            }
            try {
                if (parent != null) {
                    parent.retrieveSubFolder(fname);
                    data.addError("folder-name", (String)RESOURCE_EXISTS_ERROR.localize(req));
                }
            }
            catch (DataObjectNotFoundException e) {
                // empty catch block
            }
        }
    }
}

