/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz.ui;

import com.arsdigita.atoz.AtoZ;
import com.arsdigita.atoz.AtoZAtomicEntry;
import com.arsdigita.atoz.AtoZCompoundEntry;
import com.arsdigita.atoz.AtoZEntry;
import com.arsdigita.atoz.AtoZGenerator;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.xml.Element;

public class AtoZPane
extends SimpleContainer {
    private static final String XMLNS = "http://xmlns.redhat.com/atoz/1.0";
    private StringParameter m_letter;

    public AtoZPane(StringParameter letter) {
        this.m_letter = letter;
    }

    public void generateXML(PageState state, Element parent) {
        int i;
        AtoZ atoz = (AtoZ)Kernel.getContext().getResource();
        AtoZGenerator[] generators = atoz.getGenerators();
        String currentLetter = (String)state.getValue((ParameterModel)this.m_letter);
        if (currentLetter != null) {
            currentLetter = currentLetter.toLowerCase();
        }
        Element content = AtoZ.newElement("atoz");
        for (i = 0; i < 26; ++i) {
            String letter = new String(new char[]{(char)(97 + i)});
            Element el = AtoZ.newElement("letter");
            el.setText(letter);
            if (letter.equals(currentLetter)) {
                el.addAttribute("isSelected", "yes");
            }
            content.addContent(el);
        }
        parent.addContent(content);
        if (currentLetter == null) {
            return;
        }
        for (i = 0; i < generators.length; ++i) {
            this.generateAtoZ(generators[i], currentLetter, content);
        }
    }

    private void generateAtoZ(AtoZGenerator generator, String letter, Element parent) {
        AtoZEntry[] entries = generator.getEntries(letter);
        Element content = AtoZ.newElement("provider");
        content.addAttribute("title", generator.getTitle());
        content.addAttribute("description", generator.getDescription());
        this.generateAtoZEntries(entries, content);
        parent.addContent(content);
    }

    public void generateAtoZEntries(AtoZEntry[] entries, Element parent) {
        for (int i = 0; i < entries.length; ++i) {
            AtoZEntry entry = entries[i];
            if (entry instanceof AtoZAtomicEntry) {
                this.generateAtoZAtomicEntry((AtoZAtomicEntry)entry, parent);
                continue;
            }
            if (entry instanceof AtoZCompoundEntry) {
                this.generateAtoZCompoundEntry((AtoZCompoundEntry)entry, parent);
                continue;
            }
            throw new RuntimeException("Unknown A-Z entry type " + entry.getClass());
        }
    }

    private void generateAtoZAtomicEntry(AtoZAtomicEntry entry, Element parent) {
        Element content = AtoZ.newElement("atomicEntry");
        content.addAttribute("title", entry.getTitle());
        content.addAttribute("description", entry.getDescription());
        content.addAttribute("url", entry.getLink());
        if (entry.getContent() != null) {
            content.addContent(entry.getContent());
        }
        parent.addContent(content);
    }

    private void generateAtoZCompoundEntry(AtoZCompoundEntry entry, Element parent) {
        Element content = AtoZ.newElement("compoundEntry");
        content.addAttribute("title", entry.getTitle());
        content.addAttribute("description", entry.getDescription());
        parent.addContent(content);
        this.generateAtoZEntries(entry.getEntries(), content);
    }
}

