/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz.ui.admin;

import com.arsdigita.atoz.AtoZ;
import com.arsdigita.atoz.CategoryProvider;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.categorization.Category;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.io.IOException;

public class CategoryProviderBlackList
extends SimpleContainer {
    private ACSObjectSelectionModel m_provider;
    private static final String DELETE = "delete";

    public CategoryProviderBlackList(ACSObjectSelectionModel provider) {
        this.m_provider = provider;
    }

    public void respond(PageState state) {
        String key = state.getControlEventName();
        String value = state.getControlEventValue();
        if (DELETE.equals(key)) {
            Category cat = (Category)DomainObjectFactory.newInstance((OID)OID.valueOf((String)value));
            CategoryProvider provider = (CategoryProvider)this.m_provider.getSelectedObject(state);
            provider.removeBlock(cat);
        }
    }

    public void generateXML(PageState state, Element parent) {
        Element content = AtoZ.newElement("categoryProviderBlackList");
        this.exportAttributes(content);
        CategoryProvider provider = (CategoryProvider)this.m_provider.getSelectedObject(state);
        DomainCollection entries = provider.getBlackList();
        while (entries.next()) {
            Element el = AtoZ.newElement("categoryProviderBlock");
            try {
                state.setControlEvent((Component)this, DELETE, entries.getDomainObject().getOID().toString());
                el.addAttribute("deleteURL", state.stateAsURL());
                state.clearControlEvent();
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException("damn", (Throwable)ex);
            }
            DomainObjectXMLRenderer xr = new DomainObjectXMLRenderer(el);
            xr.setWrapRoot(false);
            xr.setWrapAttributes(true);
            xr.setWrapObjects(false);
            xr.walk(entries.getDomainObject(), CategoryProviderBlackList.class.getName());
            content.addContent(el);
        }
        parent.addContent(content);
    }
}

