/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz.ui.admin;

import com.arsdigita.atoz.AtoZ;
import com.arsdigita.atoz.CategoryProvider;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.cms.ContentType;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.io.IOException;
import javax.servlet.ServletException;

public class CategoryProviderContentTypeBlacklist
extends SimpleContainer {
    private ACSObjectSelectionModel m_provider;
    private static final String DELETE = "delete";

    public CategoryProviderContentTypeBlacklist(ACSObjectSelectionModel provider) {
        this.m_provider = provider;
    }

    public void respond(PageState state) throws ServletException {
        String key = state.getControlEventName();
        String value = state.getControlEventValue();
        if (DELETE.equals(key)) {
            ContentType contentType = (ContentType)DomainObjectFactory.newInstance((OID)OID.valueOf((String)value));
            CategoryProvider provider = (CategoryProvider)this.m_provider.getSelectedObject(state);
            provider.removeContentTypeBlock(contentType);
        }
    }

    public void generateXML(PageState state, Element parent) {
        Element content = AtoZ.newElement("categoryProviderContentTypeBlackList");
        this.exportAttributes(content);
        CategoryProvider provider = (CategoryProvider)this.m_provider.getSelectedObject(state);
        DomainCollection entries = provider.getContentTypeBlackList();
        while (entries.next()) {
            Element el = AtoZ.newElement("categoryProviderContentTypeBlock");
            try {
                state.setControlEvent((Component)this, DELETE, entries.getDomainObject().getOID().toString());
                el.addAttribute("deleteURL", state.stateAsURL());
                state.clearControlEvent();
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException("damn", (Throwable)ex);
            }
            DomainObjectXMLRenderer xr = new DomainObjectXMLRenderer(el);
            xr.setWrapRoot(false);
            xr.setWrapAttributes(true);
            xr.setWrapObjects(false);
            xr.walk(entries.getDomainObject(), CategoryProviderContentTypeBlacklist.class.getName());
            content.addContent(el);
        }
        parent.addContent(content);
    }
}

