/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz.ui.admin;

import com.arsdigita.atoz.ItemAlias;
import com.arsdigita.atoz.ItemProvider;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.categorization.CategorizedCollection;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.util.Classes;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.TooManyListenersException;

public class ItemProviderAliasForm
extends Form {
    private ACSObjectSelectionModel m_provider;
    private TextField m_title;
    private SingleSelect m_letter;
    private OptionGroup m_item;
    private SaveCancelSection m_buttons;

    public ItemProviderAliasForm(ACSObjectSelectionModel provider) {
        super("itemAliasForm", (Container)new SimpleContainer());
        this.setRedirecting(true);
        this.m_provider = provider;
        this.m_title = new TextField("title");
        this.m_title.addValidationListener((ParameterListener)new StringInRangeValidationListener(1, 200));
        this.m_title.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_title.setSize(80);
        this.m_letter = new SingleSelect("letter");
        this.m_letter.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_letter.addOption(new Option(null, "--Select one--"));
        for (int i = 0; i < 26; ++i) {
            String letter = new String(new char[]{(char)(97 + i)});
            this.m_letter.addOption(new Option(letter, letter.toUpperCase()));
        }
        this.m_item = new SingleSelect((ParameterModel)new StringParameter("item"));
        try {
            this.m_item.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent event) {
                    SingleSelect group = (SingleSelect)event.getTarget();
                    PageState state = event.getPageState();
                    boolean valueSet = false;
                    Category category = ((ItemProvider)ItemProviderAliasForm.this.m_provider.getSelectedObject(state)).getCategory();
                    CategorizedCollection children = category.getObjects("com.arsdigita.cms.ContentItem");
                    children.addOrder("name");
                    while (children.next()) {
                        ACSObject item = (ACSObject)children.getDomainObject();
                        if (!(item instanceof ContentItem) || !((ContentItem)item).getVersion().equals("draft")) continue;
                        group.addOption(new Option(item.getID().toString(), ((ContentItem)item).getName()));
                    }
                }
            });
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException((Throwable)e);
        }
        this.add((Component)this.m_title);
        this.add((Component)this.m_letter);
        this.add((Component)this.m_item);
        this.m_buttons = new SaveCancelSection((Container)new SimpleContainer());
        this.add((Component)this.m_buttons);
        this.addProcessListener(new ProviderProcessListener());
        this.addSubmissionListener(new ProviderSubmissionListener());
    }

    private class ProviderProcessListener
    implements FormProcessListener {
        private ProviderProcessListener() {
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            ItemProvider provider = (ItemProvider)ItemProviderAliasForm.this.m_provider.getSelectedObject(state);
            BigDecimal itemId = new BigDecimal(ItemProviderAliasForm.this.m_item.getValue(state).toString());
            ContentItem item = new ContentItem(itemId);
            String letter = (String)ItemProviderAliasForm.this.m_letter.getValue(state);
            String title = (String)ItemProviderAliasForm.this.m_title.getValue(state);
            ItemAlias alias = (ItemAlias)((Object)Classes.newInstance(ItemAlias.class));
            alias.setTitle(title);
            alias.setLetter(letter);
            alias.setContentItem(item);
            alias.setItemProvider(provider);
            alias.save();
            ItemProviderAliasForm.this.fireCompletionEvent(state);
        }
    }

    private class ProviderSubmissionListener
    implements FormSubmissionListener {
        private ProviderSubmissionListener() {
        }

        public void submitted(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            if (ItemProviderAliasForm.this.m_buttons.getCancelButton().isSelected(state)) {
                ItemProviderAliasForm.this.fireCompletionEvent(state);
                throw new FormProcessException("cancel hit");
            }
        }
    }
}

